/*
 * ============================================================================
 *  Name     : CCalculationInterfaceDefinition from EComInterfaceDefinition.h
 *  Part of  : EComCalculator
 *  Created  : 17/11/2003 by Forum Nokia
 *  Version  : 1.0
 *  Copyright: Nokia Corporation
 * ============================================================================
 */

#ifndef __CCALCULATE_INTERFACEDEFINITION__
#define __CCALCULATE_INTERFACEDEFINITION__

#include <e32base.h>
#include <ECom.h>
#include <badesca.h>

/**
 * Constant:    KCalculateInterfaceDefinitionUid
 *
 * Description: UID of this ECOM interface. It should be unique in the system.
 *              It is used to identify this specific custom interface.
 *              Implementations of this interface will use this ID, when they
 *              publish the implementation. Clients use this UID to search for
 *              implementations for this interface (the
 *              EcomInterfaceDefinition.inl does this).
 */
#ifdef __SERIES60_3X__
    const TUid KCalculateInterfaceDefinitionUid = {0xE0009DC1};
#else
    const TUid KCalculateInterfaceDefinitionUid = {0x10009DC1};
#endif

/**
 * Class:       CCalculationInterfaceDefinition
 *
 * Description: Custom ECOM interface definition. This interface is used by
 *              clients to find specific instance and do corresponding
 *              calculation operation for given too numbers. Plugin
 *              implementations implement the Calculate function.
 */
class CCalculationInterfaceDefinition : public CBase
    {
public: // Wrapper functions to handle ECOM "connectivity".
        // These are implemented in EComInterfaceDefinition.inl.
        // These functions are used only by the client.
    /**
     * Function:   NewL
     *
     * Description: Wraps ECom object instantitation. Will search for
     *              interface implementation, which matches to given
     *              aOperationName.
     *
     * Param:       aOperationName name of requested implementation.
     *              Implementations advertise their "name" as specified
     *              in their resource file field
     *                 IMPLEMENTATION_INFO::default_data.
     *              For details, see EcomInterfaceDefinition.inl comments.
     *              In this example, the allowed values are "sum" and
     *              "multiply".
     *
     * Note:        This is not a "normal" NewL method, since normally NewL
     *              methods are only defined for concrete classes.
     *              Note that also implementations of this interface provide
     *              NewL methods. They are the familiar NewL's, which create
     *              instance of classes.
     */
    static CCalculationInterfaceDefinition* NewL(const TDesC8& aOperationName);

    /**
     * Function:   ~CCalculationInterfaceDefinition
     *
     * Description: Wraps ECom object destruction. Notifies the ECOM
     *              framework that specific instance is being destroyed.
     *              See EcomInterfaceDefinition.inl for details.
     */
    virtual ~CCalculationInterfaceDefinition();

public: // Public pure virtual functions, which are implemented by
        // interface implementations (See ..\plugin)

    /**
     * Function:    Calculate
     *
     * Description: Public interface service. Implementation does some
     *              calculation for given a and b. The result of calculation
     *              depends on the implementation.
     *
     * Param:       aA one of the numbers used for calculation
     *
     * Param:       aB the other of the numbers used for calculation
     *
     * Returns:     Result of calculation.
     */
    virtual TReal Calculate(TReal aA, TReal aB) = 0;

private:

    /** iDtor_ID_Key Instance identifier key. When instance of an
     *               implementation is created by ECOM framework, the
     *               framework will assign UID for it. The UID is used in
     *               destructor to notify framework that this instance is
     *               being destroyed and resources can be released.
     */
    TUid iDtor_ID_Key;
    };

#include "EcomInterfaceDefinition.inl" // Our own base implementations for ECOM

#endif // __CCALCULATE_INTERFACEDEFINITION__
