/*
 * ============================================================================
 *  Name     : CImplementationClassPlus from EComImplementationPlus.h
 *  Part of  : EComCalculator
 *  Created  : 17/11/2003 by Forum Nokia
 *  Version  : 1.0
 *  Copyright: Nokia Corporation
 * ============================================================================
 */

#ifndef __ECOMIMPLEMENTATIONPLUS_
#define __ECOMIMPLEMENTATIONPLUS_

#include "EComInterfaceDefinition.h"

/**
 * Class:       CImplementationClassPlus
 *
 * Description: An implementation of the CCalculationInterfaceDefinition
 *              definition. Calculates sum of two numbers. This is concrete
 *              class, instance of which ECOM framework gives to ECOM clients.
 */
class CImplementationClassPlus : public CCalculationInterfaceDefinition
    {
public:

    /**
     * Function:    NewL
     *
     * Description: Create instance of concrete implementation. Note that ECOM
     *              interface implementations can only have two signatures for
     *              NewL:
     *               - NewL without parameters (used here)
     *               - NewL with TAny* pointer, which may provide some client
     *                 data
     *
     * Returns:    Instance of this class.
     *
     * Note:       The interface, which is abstract base class of this
     *             implementation, also provides NewL method. Normally abstract
     *             classes do not provide NewL, because they cannot create
     *             instances of themselves. See ..\interface for more info.
     */
    static CImplementationClassPlus* NewL();

    /**
     * Function:   ~CImplementationClassPlus
     *
     * Description: Destructor
     */
    ~CImplementationClassPlus();

    /**
     * Function:    Calculate
     *
     * Description: Calculates sum of a and b. Is implementation of the one
     *              CCalculationInterfaceDefinition pure virtual method.
     *
     * Returns:     Result of calculation. Sum of aA and aB.
     */
    TReal Calculate(TReal aA, TReal aB);

private: // Construction

    /**
     * Function:   CImplementationClassPlus
     *
     * Discussion: Perform the first phase of two phase construction
     */
    CImplementationClassPlus();

    /**
     * Function:   ConstructL
     *
     * Discussion: Perform the second phase construction of a
     *             CImplementationClassPlus object.
     */
    void ConstructL();

    };

#endif // __ECOMIMPLEMENTATIONPLUS_
