/*
 * ============================================================================
 *  Name     : CImplementationClassMultiply from EComImplementationMultiply.cpp
 *  Part of  : EComCalculator
 *  Created  : 17/11/2003 by Forum Nokia
 *  Version  : 1.0
 *  Copyright: Nokia Corporation
 * ============================================================================
 */

#include "EComImplementationMultiply.h"

// Create instance of concrete ECOM interface implementation
CImplementationClassMultiply* CImplementationClassMultiply::NewL()
    {
    CImplementationClassMultiply* self =
        new(ELeave) CImplementationClassMultiply();
    CleanupStack::PushL(self);
    self->ConstructL();
    CleanupStack::Pop(self);
    return self;
    }

// Destructor
CImplementationClassMultiply::~CImplementationClassMultiply()
    {
    }

// Constructor
CImplementationClassMultiply::CImplementationClassMultiply()
    {
    }

// Second phase construction.
void CImplementationClassMultiply::ConstructL()
    {
    // This implementation is simple enough so no special construction needed.

    }

// Implementation of CCalculationInterfaceDefinition
TReal CImplementationClassMultiply::Calculate(TReal aA, TReal aB)
    {
        return aA * aB;
    }
