/*
 * ============================================================================
 *  Name     : CImplementationClassPlus from EComImplementationPlus.cpp
 *  Part of  : EComCalculator
 *  Created  : 17/11/2003 by Forum Nokia
 *  Version  : 1.0
 *  Copyright: Nokia Corporation
 * ============================================================================
 */

#include "EComImplementationPlus.h"

// Create instance of concrete ECOM interface implementation
CImplementationClassPlus* CImplementationClassPlus::NewL()
    {
    CImplementationClassPlus* self=new(ELeave) CImplementationClassPlus();
    CleanupStack::PushL(self);
    self->ConstructL();
    CleanupStack::Pop(self);
    return self;
    }

// Destructor.
CImplementationClassPlus::~CImplementationClassPlus()
    {
    }

// Constructor
CImplementationClassPlus::CImplementationClassPlus()
    {
    }

// Second phase construction.
void CImplementationClassPlus::ConstructL()
    {
    // This implementation is simple enough so no special construction needed.
    }

// Implementation of CCalculationInterfaceDefinition
TReal CImplementationClassPlus::Calculate(TReal aA, TReal aB)
    {
        return aA + aB;
    }
