/*
 * ============================================================================
 *  Name     : EComProxy entry point from proxy.cpp
 *  Part of  : EComCalculator
 *  Created  : 29/05/2006 by Forum Nokia
 *  Version  : 2.0
 *  Copyright: Nokia Corporation
 * ============================================================================
 */

#include <e32std.h>
#include <ImplementationProxy.h>

#include "EComImplementationPlus.h"
#include "EComImplementationMultiply.h"

// Map the interface implementation UIDs to implementation factory functions
const TImplementationProxy ImplementationTable[] =
    {
        #ifdef __SERIES60_3X__
            IMPLEMENTATION_PROXY_ENTRY(0xE0009DC7,  CImplementationClassPlus::NewL),
            IMPLEMENTATION_PROXY_ENTRY(0xE0009DC8,  CImplementationClassMultiply::NewL)
        #else
            {{0x10009DC7},  CImplementationClassPlus::NewL},
            {{0x10009DC8},  CImplementationClassMultiply::NewL}
        #endif
    };


// Exported proxy for instantiation method resolution.
EXPORT_C const TImplementationProxy* ImplementationGroupProxy(
    TInt& aTableCount)
    {
    aTableCount = sizeof(ImplementationTable) / sizeof(TImplementationProxy);
    return ImplementationTable;
    }
