// Copyright (c) 2008-2009 Nokia Corporation and/or its subsidiary(-ies).
// All rights reserved.
// This component and the accompanying materials are made available
// under the terms of "Eclipse Public License v1.0"
// which accompanies this distribution, and is available
// at the URL "http://www.eclipse.org/legal/epl-v10.html".
//
// Initial Contributors:
// Nokia Corporation - initial contribution.
//
// Contributors:
//
// Description:
//

#ifndef CINVERTER_H_
#define CINVERTER_H_
#include "e32base.h" //for using CPeriodic
#include "e32msgqueue.h" 

class CInverter 
{
public:
	static CInverter* NewL();
	virtual ~CInverter();
	void Start();
	
	//Recieve message from the messagequeue.
	TInt RecieveMsg(); 	
	
	//Send message to the InverterOutQ.
	void SendMsg();		
	
	void Stop();  
	
	//A callback function to be called whenever the timer expires after certain interval of time . 
	TInt static StaticWake(TAny*); 
	
	void ConstructL();
	
	//Invert the user words input by the user.
	void DoInvert();
	
	//Reverse the word of the sentence coming to the Inverter.
	void ReverseWord(TBuf<20> buf);
	
private:
	// A periodic timer to be used to wake the inverter to start recieving the messages . 
	CPeriodic *iTimer;
	
	//Message queues to be opened and used to send data to inverter. 
	RMsgQueue <TBuf<100> > iOutMsgQ; 	  
	
	//Message queues to be opened and used to recieve data from inverter. 
	RMsgQueue <TBuf<100> > iInMsgQ;
	
	//Buffer to store inverted message.
	TBuf<100> iMsgQData; 
	
	//Buffer to store the message to be sent to InverterOutQ.
	TBuf<100> idestMsg;
	
	//Temporary buffers to reverse the words of the sentence.
	TBuf<20> iwords;
	TBuf<20> itmpWord; 
};

#endif /*CINVERTER_H_*/
