// Copyright (c) 2008-2009 Nokia Corporation and/or its subsidiary(-ies).
// All rights reserved.
// This component and the accompanying materials are made available
// under the terms of "Eclipse Public License v1.0"
// which accompanies this distribution, and is available
// at the URL "http://www.eclipse.org/legal/epl-v10.html".
//
// Initial Contributors:
// Nokia Corporation - initial contribution.
//
// Contributors:
//
// Description:
//

#ifndef CCOLLECTOR_H_
#define CCOLLECTOR_H_


#include <e32base.h>
#include <e32cons.h>
#include "e32std.h"
#include "e32msgqueue.h" 
#include "CMsgQActive.h"
/*This Class is used to get user input from the console and display the final output
 * to the user.
 */
class CCollector : public CActive
{
public:
 enum TRequestType {ECount, EStop} ;

public: 
 static CCollector* NewL(TInt aPriority = EPriorityStandard);
 CCollector(TInt aPriority = EPriorityStandard );
 virtual void DoCancel(); 
 virtual void RunL(); 
 void RequestFunction();
 void Stop();
 CCollector();
 virtual ~CCollector();
 void ConstructL();
 void ProcessKeyPress(TChar aChar);
 void StartRecieving();
 void SendMsgInQ(TBuf<100>);
private:
	TBuf<100> iBuf; //buffer to store words.
	CMsgQActive* iRcvInverterInQ;
	
	RMsgQueue<TBuf<100> > iInverterInQ;		  //message queues to be created and used to send data to inverter. 
	RMsgQueue<TBuf<100> > iInverterOutQ;		  //message queues to be created and used to recieve data from inverter. 
	RProcess process; //Inverter process.
	CConsoleBase* iConsole;
};

GLDEF_C TInt E32Main();

#endif /*CCollector_H_*/
