// Copyright (c) 2008-2009 Nokia Corporation and/or its subsidiary(-ies).
// All rights reserved.
// This component and the accompanying materials are made available
// under the terms of "Eclipse Public License v1.0"
// which accompanies this distribution, and is available
// at the URL "http://www.eclipse.org/legal/epl-v10.html".
//
// Initial Contributors:
// Nokia Corporation - initial contribution.
//
// Contributors:
//
// Description:
// Contains the declaration of constants needed by the source files of the example.
//



/**
 @file
*/
#ifndef __SHAREDMEM_H__
#define __SHAREDMEM_H__

#include <e32property.h>
#include <e32base.h>
#include <e32cons.h>
#include <e32std.h>
#include <e32math.h>

_LIT(KChunkName,"chunk");
_LIT(KMutexName,"mutex");
_LIT(KCondVarName,"condvar");

_LIT(KTxtEPOC32EX,"EXAMPLES");
_LIT(KTxtExampleCode,"Symbian platform Example Code");
_LIT(KFormatFailed,"failed: leave code=%d");
_LIT(KTxtOK,"ok");
_LIT(KTxtPressAnyKey," [press any key]");

/**
The size of the shared memory chunk in bytes.
*/
const TInt KChunkSize = 1;

/**
The lower threshold for the shared memory variable.
*/
const TInt KLowerThreshold = 10;

/**
The upper threshold for the shared memory variable.
*/
const TInt KUpperThreshold = 20;

/**
The maximum value for the shared memory variable.
*/
const TInt KMaxValue = 30;

/**
The minimum value for the shared memory variable.
*/
const TInt KMinValue = 0;
#endif
