// Copyright (c) 2008-2009 Nokia Corporation and/or its subsidiary(-ies).
// All rights reserved.
// This component and the accompanying materials are made available
// under the terms of "Eclipse Public License v1.0"
// which accompanies this distribution, and is available
// at the URL "http://www.eclipse.org/legal/epl-v10.html".
//
// Initial Contributors:
// Nokia Corporation - initial contribution.
//
// Contributors:
//
// Description:
// Defines the CSubtractor class.
//



/**
 @file
*/
#ifndef __SUBTRACTOR_H__
#define __SUBTRACTOR_H__

#include "sharedmem.h"

/**
The subtractor class.
This class opens the global chunk and periodically subtracts random values from it.
The condition variable ensures that the value of the chunk is always greater than 0.
*/
class CSubtractor : public CActive
	{
public:
	static CSubtractor* NewL(CConsoleBase* aConsole);
	void RunL();
	void DoCancel();
	~CSubtractor();
	void StartTimer();
	void StopTimer();
	void ReadFunction();
	static TInt SubtractFunction(TAny* aPtr);
	void Subtract();
private:
	CSubtractor();
	void ConstructL(CConsoleBase* aConsole);
private:
	/**
	The global condition variable.
	It ensures that the value of the shared chunk is always greater than 0.
	*/
	RCondVar iCondVar;
	/**
	The mutex variable.
	*/
	RMutex iMutex;
	/**
	The global chunk shared between the adder and the subtractor processes.
	@see CAdder.
	*/
	RChunk iChunk;
	/**
	The timer object.
	It periodically invokes the SubtractFunction() function.
	*/
	CPeriodic* iPeriodic;
	/**
	The user console.
	*/
	CConsoleBase* iConsole;
	};
	
#endif
