// Copyright (c) 2008-2009 Nokia Corporation and/or its subsidiary(-ies).
// All rights reserved.
// This component and the accompanying materials are made available
// under the terms of "Eclipse Public License v1.0"
// which accompanies this distribution, and is available
// at the URL "http://www.eclipse.org/legal/epl-v10.html".
//
// Initial Contributors:
// Nokia Corporation - initial contribution.
//
// Contributors:
//
// Description:
// Encapsulates both issuing a request to an asynchronous service provider 
// and handling the completed requests.
//



/**
 @file
*/

#include "mAsyncWaiter.h"

/**
 Creates an object of CMessAsyncWaiter.
*/  
CMessAsyncWaiter* CMessAsyncWaiter::NewL()
	{
	CMessAsyncWaiter* self = new(ELeave) CMessAsyncWaiter();
	return self;
	}

/**
Adds the active object to the scheduler.
*/
CMessAsyncWaiter::CMessAsyncWaiter() : CActive(EPriorityStandard)
	{
	CActiveScheduler::Add(this);
	}	


CMessAsyncWaiter::~CMessAsyncWaiter()
	{
	Cancel();
	}
	
/**
Indicates that the active object has issued a request 
and that it is now outstanding.
*/ 
void CMessAsyncWaiter::StartAndWait()
	{
	SetActive();
	CActiveScheduler::Start();
	}
	

TInt CMessAsyncWaiter::Result() const
	{
	return iError;
	}
	
/**
Handles an active objects request completion event.
It sets to run the desired task.
*/ 
void CMessAsyncWaiter::RunL()
	{
	iError = iStatus.Int();
	CActiveScheduler::Stop();
	}
	
/**
Implements cancellation of an outstanding request,
called as part of the active object's Cancel().
*/
void CMessAsyncWaiter::DoCancel()
	{
	iError = KErrCancel;
	CActiveScheduler::Stop();
	}

