// Copyright (c) 2008-2009 Nokia Corporation and/or its subsidiary(-ies).
// All rights reserved.
// This component and the accompanying materials are made available
// under the terms of "Eclipse Public License v1.0"
// which accompanies this distribution, and is available
// at the URL "http://www.eclipse.org/legal/epl-v10.html".
//
// Initial Contributors:
// Nokia Corporation - initial contribution.
//
// Contributors:
//
// Description:
// Contains the definition of the CSmpExample class.
//


#ifndef CSMPEXAMPLE_H_
#define CSMPEXAMPLE_H_

#include <e32cons.h>
#include <e32base.h>  //Used for CBase.
#include <s32file.h>  //Used for CFileStore class.
/**
This class creates three threads to demonstrate multithreading
in a unicore and a SMP environment. 
*/
class CSmpExample : public CBase
    {  
public:    
    virtual ~CSmpExample();
    static CSmpExample* NewL();
    void CreateDatabaseL(const TDesC & aDbName);	 
    static TInt ReadThreadFuncL(TAny* aPtr);
    static TInt WriteThread1FuncL(TAny* aPtr);
    static TInt WriteThread2FuncL(TAny* aPtr);
    static void ReadBothDatabasesL();    
    static void ReadDatabaseL(const TDesC& aDbName, CConsoleBase& console);   
    static void WriteDbFuncL(const TDesC& aDbName, TInt aNum);  
    void PrintMessage(); 
    void StartThreads();   
    
protected: 
	void ConstructL();
	
private: 
    //Thread to read data from the database.
    RThread iReadThread;
    //Threads to write data to the database.
    RThread iWriteThread1;
    RThread iWriteThread2;    
    CConsoleBase* iConsole; 
    };

#endif /*CSMPEXAMPLE_H_*/
