/*
 * Copyright  2008 Nokia Corporation.
 */

#ifndef __DBMSAPPVIEW_H__
#define __DBMSAPPVIEW_H__

#include <coecntrl.h>

/**
 * Class:       CDBMSAppView
 *
 * Description: An instance of this class is the Application View object for
 *              the DBMS example application.
 *
 *              The view simply shows empty screen. The Avkon GUI is just a
 *              simple tester of the database engine CDBMSDb in
 *              DBEngine.h. There is no functionality for the view, since
 *              all GUI actions relate to menu commands (see AppUi).
 */
class CDBMSAppView : public CCoeControl
    {
public:

    /**
     * Function:    NewL
     *
     * Description: Create a CDBMSAppView object, which will draw
     *              itself to aRect.
     *
     * Param:       aRect the rectangle this view will be drawn to
     *
     * Returns:     A pointer to the created instance of CDBMSAppView
     */
    static CDBMSAppView* NewL(const TRect& aRect);

    /**
     * Function:    ~CDBMSAppView
     *
     * Description: Destroy the view object
     */
     ~CDBMSAppView();

public:  // from CCoeControl

    /**
     * Function:     Draw
     *
     * Description:  Paints this view (an empty rect). This is called by the
     *               framework, when view needs to redraw itself.
     *
     * Param:        aRect Frame rectangle for container.
     */
    void Draw(const TRect& aRect) const;

private:

    /**
     * Function:    ConstructL
     *
     * Description: Perform the second phase construction of a
     *              CDBMSAppView object.
     *
     * Param:       aRect the rectangle this view will be drawn to
     */
    void ConstructL(const TRect& aRect);

    /**
     * Function:   CDBMSAppView
     *
     * Description: Perform the first phase of two phase construction.
     */
    CDBMSAppView();

private: // private attributes

    };

#endif // __DBMSAPPVIEW_H__
