/*
 * Copyright  2008 Nokia Corporation.
 */

#ifndef __DBMS_APPLICATION_H__
#define __DBMS_APPLICATION_H__

#include <aknapp.h>


/**
 * Class:       CEComCalculatorApplication
 *
 * Description: An instance of CDBMSApplication is the application
 *              part of the AVKON application framework for the DBMS
 *              example application.
 *
 *              The relevant part of this example is the database engine class
 *              CDBMSDb in DBEngine.h. The AVKON GUI is only a simple
 *              tester for the engine.
 */
class CDBMSApplication : public CAknApplication
    {
public: // from CAknApplication

    /**
     * Function:    AppDllUid
     * Description: Return the application DLL UID value
     * Returns:     The UID of this Application Dll
     */
    TUid AppDllUid() const;


protected: // from CAknApplication

    /**
     * Function:    CreateDocumentL
     * Description: Create a CApaDocument object and return a pointer to it.
     * Returns:     A pointer to the created document
     */
    CApaDocument* CreateDocumentL();
    };

#endif // __DBMS_APPLICATION_H__
