/*
 * Copyright  2008 Nokia Corporation.
 */

#ifndef __DBMSDOCUMENT_H__
#define __DBMSDOCUMENT_H__


#include <akndoc.h>

// Forward declarations
class CDBMSAppUi;
class CEikApplication;


/**
 * Class:      CDBMSDocument
 *
 * Discussion: An instance of class CDBMSDocument is the Document
 *             part of the AVKON application framework for the DBMS
 *             example application.
 */
class CDBMSDocument : public CAknDocument
    {
public:

    /**
     * Function:   NewL
     *
     * Discussion: Construct a CDBMSDocument for the AVKON application
     *             aApp using two phase construction, and return a pointer
     *             to the created object.
     *
     * Param:      aApp application creating this document
     *
     * Returns:    A pointer to the created instance of CDBMSDocument
     */
    static CDBMSDocument* NewL(CEikApplication& aApp);

    /**
     * Function:   ~CDBMSDocument
     *
     * Discussion: Destroy the object
     */
    ~CDBMSDocument();

private:

    /**
     * Function:   ConstructL
     *
     * Discussion: Perform the second phase construction of a
     *             CDBMSDocument object.
     */
    void ConstructL();

    /**
     * Function:   CDBMSDocument
     *
     * Discussion: Perform the first phase of two phase construction
     *
     * Param:      aApp application creating this document
     */
    CDBMSDocument(CEikApplication& aApp);

private: // From CAknDocument

    /**
     * Function:   CreateAppUiL
     *
     * Discussion: Create the AppUi object and return a pointer to it.
     *
     * Returns:    A pointer to the created instance of the AppUi
     */
    CEikAppUi* CreateAppUiL();
    };


#endif // __DBMSDOCUMENT_H__
