/*
 * Copyright  2008 Nokia Corporation.
 */

#ifndef __DBMSLISTBOXVIEW_H__
#define __DBMSLISTBOXVIEW_H__

#include <coecntrl.h>

// Forward declarations
class CEikLabel;
class CEikTextListBox;


/**
 * Class:       CDBMSListboxView
 *
 * Description: An instance of this class is an Application View object for
 *              the DBMS example application.
 *
 *              This is window owning container control.It shows label and
 *              a single listbox. The listbox is used to
 *              - show the columns of the Books table
 *              - show book names (titles) in the database
 */
class CDBMSListboxView : public CCoeControl
    {

public:

    /**
     * Function:    NewL
     *
     * Description: Create a CDBMSListboxView object, which will draw
     *              itself to aRect.
     *
     * Param:       aRect the rectangle this view will be drawn to
     *
     * Returns:     A pointer to the created instance of CDBMSListboxView
     */
    static CDBMSListboxView* NewL(const TRect& aRect);

    /**
     * Function:    ~CDBMSAppView
     *
     * Description: Destroy the view object
     */
     ~CDBMSListboxView();

    /**
     * Function:    SetCaptionL
     *
     * Description: Sets new caption for the view.
     *
     * Param:       aNewCaption new value for the caption.
     */
    void SetCaptionL(const TDesC& aNewCaption);

    /**
     * Function:    SetListItemsL
     *
     * Description: Sets the list box items. The listbox takes ownership
     *              of the aNewItems array.
     *
     * Param:       aNewItems Array of descriptors to be shown in the listbox.
     */
    void SetListItemsL(CDesCArrayFlat* aNewItems);

    /**
     * Function:    GetSelectedItem
     *
     * Description: Get name of the selected item in the listbox.
     *
     * Param:       aResult The result is placed here. Provide descriptor long
     *              enough.
     *
     * Returns:     KErrNone, if item was selected. KErrNotFound otherwise.
     */
    TInt GetSelectedItem(TDes& aResult) const;

public:  // from CCoeControl

    /**
     * Function:     Draw
     *
     * Description:  Paints this view (an empty rect). This is called by the
     *               framework, when view needs to redraw itself.
     *
     * Param:        aRect Frame rectangle for container.
     */
    void Draw(const TRect& aRect) const;

    /**
     * Function:    SizeChanged
     *
     * Description: Determines controls' sizes according to current state.
     */
    void SizeChanged();


    /**
     * Function:     CountComponentControls
     *
     * Returns:      Number of controls within this container.
     */
    TInt CountComponentControls() const;

    /**
     * Function:     ComponentControl
     *
     * Param:        aIndex of control
     *
     * Returns:      One of the controls this class owns.
     */
    CCoeControl* ComponentControl(TInt aIndex) const;

    /**
     * Function:     OfferKeyEventL
     *
     * Description:  Handles key events for this control. Forwards
     *               them to listbox
     *
     * Param:        aKeyEvent The key event.
     *
     * Param:        aType The type of the event.
     *
     * Returns:      Indicates whether or not the key event was
     *               used (consumed) by this control.
     */
    TKeyResponse OfferKeyEventL(const TKeyEvent& aKeyEvent,TEventCode aType);

private:

    /**
     * Function:    ConstructL
     *
     * Description: Perform the second phase construction of a
     *              CDBMSAppView object.
     *
     * Param:       aRect the rectangle this view will be drawn to
     */
    void ConstructL(const TRect& aRect);

    /**
     * Function:   CDBMSListboxView
     *
     * Description: Perform the first phase of two phase construction.
     */
    CDBMSListboxView();

private: // private attributes

        CEikLabel* iLabel;             // Title text for the view
        CEikTextListBox* iListBox;     // List of book names or columns
    };


#endif // __DBMSLISTBOXVIEW_H__
