/*
 * Copyright  2008 Nokia Corporation.
 */

#include "DBMSAppUi.h"
#include "DBMSDocument.h"

// ---------------------------------------------------------------------------
// CDBMSAppUi::NewL()
//
// Create instance of document.
// ---------------------------------------------------------------------------
CDBMSDocument* CDBMSDocument::NewL(CEikApplication& aApp)
    {
    CDBMSDocument* self = new (ELeave) CDBMSDocument(aApp);
    CleanupStack::PushL(self);
    self->ConstructL();
    CleanupStack::Pop(self);
    return self;
    }

// ---------------------------------------------------------------------------
// CDBMSAppUi::ConstructL()
//
// Perform second phase construction
// ---------------------------------------------------------------------------
void CDBMSDocument::ConstructL()
    {
    // No implementation required
    }

// ---------------------------------------------------------------------------
// CDBMSAppUi::CDBMSDocument()
//
// Constructor
// ---------------------------------------------------------------------------
CDBMSDocument::CDBMSDocument(CEikApplication& aApp) : CAknDocument(aApp)
    {
    // No implementation required
    }

// ---------------------------------------------------------------------------
// CDBMSAppUi::~CDBMSDocument()
//
// Destructor
// ---------------------------------------------------------------------------
CDBMSDocument::~CDBMSDocument()
    {
    // No implementation required
    }

// ---------------------------------------------------------------------------
// CDBMSAppUi::CreateAppUiL()
//
// Create the AppUi.
// ---------------------------------------------------------------------------
CEikAppUi* CDBMSDocument::CreateAppUiL()
    {
    return (static_cast<CEikAppUi*>(new(ELeave)CDBMSAppUi));
    }

