/*
 * Copyright  2008 Nokia Corporation.
 */

#include <barsread.h>  // for resource reader
#include <coemain.h>
#include "DBMSEditorView.h"
#include <DBMS.rsg> // Generated from DBMS.rss
#include <eikfrlbd.h>
#include <eiklabel.h>  // CEikLabel
#include <AknUtils.h>

// Constant texts
_LIT(KLabelTextAuthor,"Author:");
_LIT(KLabelTextTitle,"Title:");
_LIT(KLabelTextDescription, "Description:");
_LIT(KEmptyText, "None");

// ---------------------------------------------------------------------------
// CDBMSEditorView::NewL()
//
// Create instance of this compound control.
// ---------------------------------------------------------------------------
//
CDBMSEditorView* CDBMSEditorView::NewL(const TRect& aRect)
    {
    CDBMSEditorView* self = new (ELeave) CDBMSEditorView;
    CleanupStack::PushL(self);
    self->ConstructL(aRect);
    CleanupStack::Pop(self);
    return self;
    }


// ---------------------------------------------------------------------------
// CDBMSEditorView::ConstructL()
//
// Perform the second phase construction. Instantiate the owned controls.
// ---------------------------------------------------------------------------
//
void CDBMSEditorView::ConstructL(const TRect& aRect)
    {
    // Create a window for this application view
    CreateWindowL();
        
   	iItemList = new (ELeave) CAknSettingItemList;
   	iItemList->SetMopParent(this);
    iItemList->ConstructFromResourceL(R_ENTRY_SETTINGS_LIST); 
    
    LoadListL();
    
    iItemList->MakeVisible(ETrue);
    iItemList->SetRect(aRect);
    iItemList->ActivateL();
    iItemList->ListBox()->UpdateScrollBarsL();
    iItemList->DrawNow();    

    // Set the windows size
    SetRect(aRect);

    // Activate the window, which makes it ready to be drawn
    ActivateL();

    }


// ----------------------------------------------------
// CDBMSEditorView::LoadListL()
// Loads item list dynamically.
// ----------------------------------------------------
//
void CDBMSEditorView::LoadListL()
	{
	TBool isNumberedStyle = iItemList->IsNumberedStyle();
	CArrayPtr<CGulIcon>* icons = iItemList->ListBox()->ItemDrawer()->FormattedCellData()->IconArray();
	TBuf<50> aText;
	
	/*Author item*/
	
	iAuthor = new (ELeave) CAknTextSettingItem(1, aText);
	iAuthor->SetEmptyItemTextL( KEmptyText );
	// The same resource id can be used for multiple text setting pages.
	iAuthor->ConstructL(isNumberedStyle, 1, KLabelTextAuthor, icons, R_TEXT_SETTING_PAGE, -1);
	iItemList->SettingItemArray()->AppendL(iAuthor);
	
	/*Title item*/
	iTitle = new (ELeave) CAknTextSettingItem(2, aText);
	iTitle->SetEmptyItemTextL( KEmptyText );
	// The same resource id can be used for multiple text setting pages.
	iTitle->ConstructL(isNumberedStyle, 1, KLabelTextTitle, icons, R_TEXT_SETTING_PAGE, -1);
	iItemList->SettingItemArray()->AppendL(iTitle);
	
	/*Description item*/
	iDescription = new (ELeave) CAknTextSettingItem(3, aText);
	iDescription->SetEmptyItemTextL( KEmptyText );
	// The same resource id can be used for multiple text setting pages.
	iDescription->ConstructL(isNumberedStyle, 1, KLabelTextDescription, 
		icons, R_TEXT_SETTING_PAGE, -1);
	iItemList->SettingItemArray()->AppendL(iDescription);
	
	// Required when there is only one setting item.
	iItemList->SettingItemArray()->RecalculateVisibleIndicesL();

	iItemList->HandleChangeInItemArrayOrVisibilityL();

	}
// ---------------------------------------------------------------------------
// CDBMSEditorView::CDBMSEditorView()
//
// // Constructor.
// ---------------------------------------------------------------------------
//
CDBMSEditorView::CDBMSEditorView()
    {
    // No implementation required
    }


// ---------------------------------------------------------------------------
// CDBMSEditorView::~CDBMSEditorView()
//
// Destructor. Release the owned controls
// ---------------------------------------------------------------------------
//
CDBMSEditorView::~CDBMSEditorView()
    {
    delete iItemList;
    }

// ---------------------------------------------------------------------------
// CDBMSEditorView::CountComponentControls()
//
// Tell the framework the number of owned controls so that it can query them
// ---------------------------------------------------------------------------
//
TInt CDBMSEditorView::CountComponentControls() const
    {
    TInt count = 0;
	if (iItemList)
		count++;
	return count;
    //return KNumberOfControls;
    }

// ---------------------------------------------------------------------------
// CDBMSEditorView::ComponentControl()
//
// Return owned controls to framework so it will draw them.
// ---------------------------------------------------------------------------
//
CCoeControl* CDBMSEditorView::ComponentControl(TInt /*aIndex*/) const
    {
    return iItemList;
    }


// ---------------------------------------------------------------------------
// CDBMSEditorView::OfferKeyEventL()
//
// Handle key events. User of this view control must add this to control
// stack to ensure this component is able to get key events. In practise
// the AppUi does it.
// ---------------------------------------------------------------------------
//
TKeyResponse CDBMSEditorView::OfferKeyEventL(const TKeyEvent& aKeyEvent,
                            TEventCode aType)
    {
    if(aType != EEventKey)
        {
        return EKeyWasNotConsumed;
        }    
    else if(iItemList)
        {
        return iItemList->OfferKeyEventL( aKeyEvent, aType );
        }
    else
        {
        return EKeyWasNotConsumed;
        }
    }

// ---------------------------------------------------------------------------
// CDBMSEditorView::GetAuthor()
//
// Get author value from iEdwinAuthor
// ---------------------------------------------------------------------------
//
void CDBMSEditorView::GetAuthorL(TDes& aResult) const
    {
    aResult.Copy(iAuthor->SettingTextL());
    }


// ---------------------------------------------------------------------------
// CDBMSEditorView::GetTitle()
//
// Get title value from iEdwinTitle
// ---------------------------------------------------------------------------
//
void CDBMSEditorView::GetTitleL(TDes& aResult) const
    {
	aResult.Copy(iTitle->SettingTextL());
    }


// ---------------------------------------------------------------------------
// CDBMSEditorView::GetDescription()
//
// Get description value from iEdwinDescription
// ---------------------------------------------------------------------------
//
void CDBMSEditorView::GetDescriptionL(TDes& aResult) const
    {
    aResult.Copy(iDescription->SettingTextL());
    }

// ----------------------------------------------------
// CDBMSEditorView::Draw()
// This function is used for window server-initiated 
// redrawing of controls, and for some 
// application-initiated drawing.
// ----------------------------------------------------
//
void CDBMSEditorView::Draw(const TRect& /*aRect*/) const
    {
    // Get the standard graphics context 
    CWindowGc& gc = SystemGc();
    
    // Gets the control's extent
    TRect rect = Rect();
    
    // Clears the screen
    gc.Clear(rect);
    }

// ---------------------------------------------------------
// CDBMSEditorView::HandleResourceChange()
// Called by framework when resource is changed.
// ---------------------------------------------------------
//

void CDBMSEditorView::HandleResourceChange(TInt aType)
    {
    
    CCoeControl::HandleResourceChange(aType);

    // ADDED FOR SCALABLE UI SUPPORT
    // *****************************
	//if ( aType == KEikDynamicLayoutVariantSwitch )
	//hard coded constant so it can be compiled with first edition
    if ( aType==0x101F8121 )
        {
        TRect rect = Rect();
        AknLayoutUtils::LayoutMetricsRect(AknLayoutUtils::EMainPane, rect);
        SetRect(rect);
        iItemList->SetRect(rect);
        TRAP_IGNORE (iItemList->ListBox()->UpdateScrollBarsL();)
        iItemList->DrawNow();    
        } 
    }
    
