/*
 * Copyright  2008 Nokia Corporation.
 */

#include <eikenv.h>
#include <avkon.hrh>
#include <gdi.h>
#include <eiktxlbx.h>  // CEikTextListBox
#include <eiklabel.h>  // CEikLabel
#include <eiktxlbm.h>  // CTextListBoxModel
#include <aknconsts.h>
#include <AknUtils.h>
#include "DBMSListboxView.h"


// ---------------------------------------------------------------------------
// CDBMSListboxView::NewL()
//
// Create instance of this view.
// ---------------------------------------------------------------------------
//
CDBMSListboxView* CDBMSListboxView::NewL(const TRect& aRect)
    {
    CDBMSListboxView* self = new (ELeave) CDBMSListboxView;
    CleanupStack::PushL(self);
    self->ConstructL(aRect);
    CleanupStack::Pop(self);
    return self;
    }


// ---------------------------------------------------------------------------
// CDBMSListboxView::ConstructL()
//
// Perform the second phase construction. Construct the contained controls.
// ---------------------------------------------------------------------------
//
void CDBMSListboxView::ConstructL(const TRect& aRect)
    {
    // Create a window for this application view
    CreateWindowL();
	_LIT(KListboxView, "Listbox view");

    iLabel = new (ELeave) CEikLabel();
    iLabel->SetTextL(KListboxView);
    iLabel->SetContainerWindowL( *this );

    iListBox = new(ELeave)CEikTextListBox();
    iListBox->ConstructL( this);
    iListBox->SetContainerWindowL( *this );

    // Set the windows size
    SetRect(aRect);
    ActivateL();
    }


// ---------------------------------------------------------------------------
// CDBMSListboxView::SetCaptionL()
//
// Set caption for this view. Updates the label.
// ---------------------------------------------------------------------------
//
void CDBMSListboxView::SetCaptionL(const TDesC& aNewCaption)
    {
    iLabel->SetTextL(aNewCaption);
    SizeChanged();
    }


// ---------------------------------------------------------------------------
// CDBMSListboxView::SetListItemsL()
//
// Sets the listbox array and updates the view to reflect new array items.
// The listbox takes ownership of the given aNewItems array.
// ---------------------------------------------------------------------------
//
void CDBMSListboxView::SetListItemsL(CDesCArrayFlat* aNewItems)
    {
    CTextListBoxModel* model = iListBox->Model();
    model->SetItemTextArray(aNewItems);
    // Set ListBox model responsible for deleting the listItems array
    model->SetOwnershipType( ELbmOwnsItemArray );
    iListBox->HandleItemAdditionL();
    if(aNewItems->Count()>0)
        {
        // Select the first item, if there is one.
        iListBox->SetCurrentItemIndexAndDraw(0);
        }
    }


// ---------------------------------------------------------------------------
// CDBMSListboxView::CDBMSListboxView()
//
// Constructor
// ---------------------------------------------------------------------------
//
CDBMSListboxView::CDBMSListboxView()
    {
    // No implementation required
    }


// ---------------------------------------------------------------------------
// CDBMSListboxView::~CDBMSListboxView()
//
// Desctructor. Delete contained controls
// ---------------------------------------------------------------------------
//
CDBMSListboxView::~CDBMSListboxView()
    {
    delete iLabel;
    delete iListBox;
    }


// ---------------------------------------------------------------------------
// CDBMSAppUi::Draw()
//
// Draw the view background. This is called by the framework, when necessary.
//
// Note: The framework will draw the contained controls (label and the listbox)
// by using CountComponentControls() and ComponentControl() methods.
// ---------------------------------------------------------------------------
//
void CDBMSListboxView::Draw(const TRect& /*aRect*/) const
    {
    //Clear the screen
    CWindowGc& gc = SystemGc();
    gc.Clear(Rect());
    }


// ---------------------------------------------------------------------------
// CDBMSListboxView::SizeChanged()
//
// Specify locations and sizes of the label and listbox. Called by
// the framework when the view size is changed
// ---------------------------------------------------------------------------
//
void CDBMSListboxView::SizeChanged()
    {

        TRect containerRect = Rect(); // Rect of the container

        TSize labelSize = iLabel->MinimumSize();

        // Show the label in the upper part of the screen and in whole
        // screen width
        iLabel->SetExtent( TPoint(5,2),
                           TSize(containerRect.Width(), labelSize.iHeight) );

        // Fill the rest (bottom) of the screen with listbox
        iListBox->SetExtent( TPoint(5,labelSize.iHeight + 5 ),
            TSize( containerRect.Width(),
                   containerRect.Height()-labelSize.iHeight ) );
                   
    }


// ---------------------------------------------------------------------------
// CDBMSListboxView::CountComponentControls()
//
// Return number of contained controls.
// ---------------------------------------------------------------------------
//
TInt CDBMSListboxView::CountComponentControls() const
    {
        return 2; // Label and listbox
    }


// ---------------------------------------------------------
// CDBMSListboxView::ComponentControl()
//
// Return owned controls to framework so it will draw them.
// ---------------------------------------------------------
//
CCoeControl* CDBMSListboxView::ComponentControl(TInt aIndex) const
    {
    switch ( aIndex )
        {
        case 0:
            return iLabel;
        case 1:
            return iListBox;
        default:
            return NULL;
        }
    }

// ---------------------------------------------------------------------------
// CDBMSListboxView::OfferKeyEventL()
//
// Handle key events. Let the listbox handle the key events.
//
// AppUi must add this control to control stack to ensure key events are
// received and this method is called.
// ---------------------------------------------------------------------------
//
TKeyResponse CDBMSListboxView::OfferKeyEventL(const TKeyEvent& aKeyEvent,
    TEventCode aType)
    {
        return iListBox->OfferKeyEventL( aKeyEvent, aType );
    }


// ---------------------------------------------------------------------------
// CDBMSListboxView::GetSelectedItem()
//
// Get name of the selected item in the listbox.
// ---------------------------------------------------------------------------
//
TInt CDBMSListboxView::GetSelectedItem(TDes& aResult) const
    {
    CTextListBoxModel* model = iListBox->Model();
    if(model->NumberOfItems()==0)
        {
        return KErrNotFound;
        }

    aResult.Copy(model->ItemText(iListBox->CurrentItemIndex()));
    return KErrNone;
    }

//EOF
