
/*
* ==============================================================================
*  Name        : OpenCLibzheader.h
*  Part of     : OpenCLibz
*  Interface   : 
*  Description : 
*  Version     : 
*
*  Copyright (c) 2007 Nokia Corporation.
*  This material, including documentation and any related 
*  computer programs, is protected by copyright controlled by 
*  Nokia Corporation.
* ==============================================================================
*/

/** @file OpenCLibzheader.h
*/
/* INCLUDE FILES */

#include <zlib.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include<unistd.h>

/* INCLUDE FILES REQUIRED ONLY FOR MEMORY MAPPING */
#ifdef USE_MMAP
#  include <sys/types.h>
#  include <sys/mman.h>
#  include <sys/stat.h>
#endif



#ifndef GZ_SUFFIX
#  define GZ_SUFFIX ".gz"    //extension of the compressed file
#endif

#define SUFFIX_LEN (sizeof(GZ_SUFFIX)-1)

#define BUFLEN      16384
#define MAX_NAME_LEN 1024



/**
* Compresses the string
* This function compresses the string entered by the user and shows the
* compressed string and then decompressess it 
* Actually This function will show the content on the screen and demonstarte 
* how strings can be compressed
*
*/
void StringCompress();
/**
* In case of any error display the error message 
*
* @param msg  will be displayed to the user 
*
* @return No return code ,application will terminate after displaying the error message.
*/
void Error            OF((const char *msg));
/**
* Compresses the input file 
* First tries to compress using GzCompressMmap ,But if it fails it
* tries normal technique
*
* @param in is the name of input file .
* @param out is the name of output file.
* @return a Symbian OS error code.
*/
void GzCompress      OF((FILE   *in, gzFile out));
/**
* GzCompressMmap function compresses the file using mmap technique
* Compression can be done in a single step using mmap but it requires 
* enough large buffers.
* I have implemented my code such that, EvenIn case of mmap failure (because of
* shortage of buffer space) It compresses using normal technique. 
*
* @param in the name of input file. 
* @param out is the name of output file.
*/
#ifdef USE_MMAP
int  GzCompressMmap OF((FILE   *in, gzFile out));
#endif
/**
* UnCompresses the file using libz api's
*
* @param in is the name of input file .
* @param out is the name of output file.
*
*/
void GzUnCompress    OF((gzFile in, FILE   *out));
/**
* Compresses the File 
* It creates the output filename .
* It checkes for the existence of input file.
* And then it calls GzCompress .
*
* @param file is the name of the file to be compressed
* @param mode is for the technique used for opening the file.
*
*/
void FileCompress    OF((char  *file, char *mode));
/**
* It generates the output filename .
* It checks for the existence of the file and then calls GzUnCompress.
*
* @param file is the name of the compressed (.gz) file .
*
*/
void FileUnCompress  OF((char  *file));