/*
* ==============================================================================
*  Name        : OpenCLibz.c
*  Part of     : OpenCLibz
*  Interface   : 
*  Description : 
*  Version     : 
*
*  Copyright (c) 2007 Nokia Corporation.
*  This material, including documentation and any related 
*  computer programs, is protected by copyright controlled by 
*  Nokia Corporation.
* ==============================================================================
*/

//#include <staticlibinit_gcce.h>

#include "OpenCLibzheader.h"




/** @file OpenCLibz.c
 The Libz example demonstrates how to use libz library to compress files and decompress it.
 Any kind of file ( txt , doc , xls , xml , mpeg , ppt , mp3 etc) can be compressed .
 This example can compress a file as well as string and it can decompress 
 a compressed file (.gz)
*/ 




// This aplication works with eshell as well ....so i have taken care of argumets 
/* ===========================================================================
 * Usage:  OpenCLibz [-d] [-f] [-h] [-r] [-1 to -9] [files...]
 *   -d : decompress
 *   -f : compress with Z_FILTERED
 *   -h : compress with Z_HUFFMAN_ONLY
 *   -r : compress with Z_RLE
 *   -1 to -9 : compression level
 *   files : absolute path
*/
//If user runs through the icon then he will be asked to enter the options.
//
int main (int argc, char *argv[])
	{
    char outmode[20];
    char  name[20+1]; // name of the file
    int uncompr = 0;//mode parameters to choose 
	
    strcpy(outmode, "wb6 ");
    
    argc--, argv++;

    while (argc > 0) 
    {
      if (strcmp(*argv, "-d") == 0)
        uncompr = 1;
      else if (strcmp(*argv, "-f") == 0)
        outmode[3] = 'f';
      else if (strcmp(*argv, "-h") == 0)
        outmode[3] = 'h';
      else if (strcmp(*argv, "-r") == 0)
        outmode[3] = 'R';
      else if ((*argv)[0] == '-' && (*argv)[1] >= '1' && (*argv)[1] <= '9' &&
               (*argv)[2] == 0)
        outmode[2] = (*argv)[1];
      else
        break;
      argc--, argv++;
    }
    if (outmode[3] == ' ')
        outmode[3] = 0;
    if (argc == 0) 
    {
      char choice;
      printf("enter the mode to process \n \n");
      printf("  h for Huffman only compression \n");      	
      printf("  f for filtered data compression\n");
      printf("  R for run-length encoding compression\n");
      printf("  d for decompress \n ");
      printf(" s to  compress a string\n\n " );      
      
      choice = getchar();
      
      if(choice == 'd')
      uncompr = 1;
      else 
      outmode[3] = choice;
      if(choice == 's')
      {
     		StringCompress();
      }
      else if (uncompr) 
      {
            printf("enter the filename to compress....for example if log.txt.gz is there in c drive then type  \n");    
        	
        	printf(" c:\\log.txt.gz  \n\n\n");
        	
        	scanf("%20s", name);        	   
        
        	FileUnCompress(name);
      }
      else
      {  
        	printf("enter the filename to compress....for example if log.txt is there in c drive then type  \n");
        	
        	printf(" c:\\log.txt  \n\n\n");
        	
        	scanf("%20s",name);        	
	  			
        	FileCompress(name, outmode);
      }
    } 
    else
    {
        do 
        {
            if (uncompr) 
            {
                FileUnCompress(*argv);
            } else {
                FileCompress(*argv, outmode);
            }
        } while (argv++, --argc);
    }

	 getchar();
	 getchar();
	 fclose(stdin);
	 fclose(stdout);
	 fclose(stderr);


    return 0;

	}


/*  End of File */
