/*
* ==============================================================================
*  Name        : UnCompress.c
*  Part of     : OpenCLibz
*  Interface   :
*  Description :
*  Version     :
*
*  Copyright (c) 2007 Nokia Corporation.
*  This material, including documentation and any related
*  computer programs, is protected by copyright controlled by
*  Nokia Corporation.
* ==============================================================================
*/


/** @file uncompress.c
*    In this file I uncompress the file using libz api's
*    Here i make use of libz api which can read compressed files
*/
#include "OpenCLibzheader.h"

//
// In case of any error , display the error message .
//
void Error(const char * msg)
{
    printf( " %s\n",  msg);
    getchar();
    getchar();
    exit(1);
}



//Compresses the file using libz api's

void GzUnCompress(gzFile   in, FILE     * out)

{
    static char buf[BUFLEN];
    int len;
    int err;

    for (;;)
    {
        len = gzread(in, buf, sizeof(buf)); //libz api to read a compressed file
        if (len < 0) Error (gzerror(in, &err));
        if (len == 0) break;

        if ((int)fwrite(buf, 1, (unsigned)len, out) != len)
        {
            Error("failed fwrite");
        }
    }
   if (fclose(out)) Error("failed fclose");

   if (gzclose(in) != Z_OK) // libz api to close a compressed file

   Error("failed gzclose");



}




//UnCompresses the file using libz api's

void FileUnCompress( char  * file )

{
    static char buf[MAX_NAME_LEN];
    char *infile, *outfile;
    FILE  *out;
    gzFile in;
    char choice[3];
    uInt len = (uInt)strlen(file);
    strcpy(buf, file);

    if (len > SUFFIX_LEN && strcmp(file+len-SUFFIX_LEN, GZ_SUFFIX) == 0)
    {
        infile = file;
        outfile = buf;
        outfile[len-3] = '\0'; //create the output filename
    }
    else
    {
        outfile = file;
        infile = buf;
        strcat(infile, GZ_SUFFIX); //create the input filename
    }
    in = gzopen(infile, "rb"); // libz api to open a compressed file

    if (in == NULL)
    {

      Error("file not found ...try again \n");

    }
    out = fopen(outfile, "wb"); //open the output filename
    if (out == NULL)
    {
    gzclose(in);       // libz api to close a compressed file
    }

    GzUnCompress(in, out);

    printf("do you want to delete the original file (y /n) \n");

    scanf("%s",choice);

    if(choice[0] == 'y')
    unlink(file);
    printf(" Congrats .... uncompression done ...u can find uncompressed file in the same directory as of the source file\n");

}

/*  End of File */
