// Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
// All rights reserved.
// This component and the accompanying materials are made available
// under the terms of "Eclipse Public License v1.0"
// which accompanies this distribution, and is available
// at the URL "http://www.eclipse.org/legal/epl-v10.html".
//
// Initial Contributors:
// Nokia Corporation - initial contribution.
//
// Contributors:
//
// Description:
//


#ifndef __CMTPEXAMPLEDPREQUESTPROCESSOR_H__
#define __CMTPEXAMPLEDPREQUESTPROCESSOR_H__

#include <e32base.h>
#include <mtp/mtpdataproviderapitypes.h>
#include <mtp/mtpprotocolconstants.h>
#include <mtp/tmtptyperesponse.h>
#include <mtp/tmtptypenull.h>


class TMTPTypeRequest;
class CMTPDataProviderPlugin;
class MMTPDataProviderFramework;
class TMTPTypeEvent;

struct TMTPRequestElementInfo; 

/** 
 Defines a request processor interface
 */

	
class MMTPExampleDpRequestProcessor
	{
public:	
	/*
	Process a request from the initiator
	@param aRequest	The request to be processed
	@param aPhase	The transaction phase of the request
	@return ETrue to signal that the processor object can be deleted, EFalse to keep the processor object
	*/
	virtual TBool HandleRequestL(const TMTPTypeRequest& aRequest, TMTPTransactionPhase aPhase) = 0;
	
	/*
	Process an event from the initiator
	@param aEvent	The event to be processed
	*/
	virtual void HandleEventL(const TMTPTypeEvent& aEvent) = 0;
	
	/*
    Check if the processor matches the request on the connection
    @param aRequest The request to be checked
    @param aConnection The connection from which the request comes
    @return ETrue to indicate the processor can handle the request, otherwise, EFalse
    */
    virtual TBool Match(const TMTPTypeRequest& aRequest, MMTPConnection& aConnection) const = 0;
	
	/*
	Check if the processor matches the event on the connection
	@param aEvent The event to be checked
	@param aConnection The connection from which the event comes
	@return ETrue to indicate the processor can handle the event, otherwise, EFalse
	*/	
	virtual TBool Match(const TMTPTypeEvent& aEvent, MMTPConnection& aConnection) const = 0;
	
	/*
	Get the request object which the processor is currently handling
	@return the request object which the processor is currently handling
	*/
	virtual const TMTPTypeRequest& Request() const = 0;
	
	/*
	Get the connection object associated with the current request object
	@return the connection object associated with the current request object
	*/
	virtual MMTPConnection& Connection() const = 0;
    /*
    Get the Session ID associated with the current request object
    @return Session ID associated with the current request object
    */	
	
	virtual TUint32 SessionId() = 0;
   /*
    delete the request processor object
    */
    virtual void Release() = 0;

	};

/** 
 Defines a processor factory function pointer.
 */
typedef MMTPExampleDpRequestProcessor* (*TMTPRequestProcessorCreateFunc)(
																MMTPDataProviderFramework& aFramework, 
																MMTPConnection& aConnection);

/** 
 Defines an entry which maps from operation code to the request processor.
 */																
typedef struct 
	{
	TUint16							iOperationCode;
	TMTPRequestProcessorCreateFunc	iCreateFunc;
	}TMTPRequestProcessorEntry;

class CMTPExampleDpRequestProcessor : public MMTPExampleDpRequestProcessor
    {
protected:  
    CMTPExampleDpRequestProcessor(
                        MMTPDataProviderFramework& aFramework,
                        MMTPConnection& aConnection,
                        TInt aElementCount,
                        const TMTPRequestElementInfo* aElements);
    virtual ~CMTPExampleDpRequestProcessor();   

protected:  //utility methods   
    void SendResponseL(TMTPResponseCode aResponseCode, TInt aParameterCount = 0, TUint32* aParams = NULL);
    void CompleteRequestL();
        
protected:  //  from MMTPRequestProcessor   
    virtual TBool HandleRequestL(const TMTPTypeRequest& aRequest, TMTPTransactionPhase aPhase);
    virtual void HandleEventL(const TMTPTypeEvent& aEvent);
    virtual void Release();
    virtual TBool Match(const TMTPTypeRequest& aRequest, MMTPConnection& aConnection) const;
    virtual TBool Match(const TMTPTypeEvent& aEvent, MMTPConnection& aConnection) const;  
    virtual const TMTPTypeRequest& Request() const;
    virtual MMTPConnection& Connection() const;
    virtual TUint32 SessionId();


protected:  //new virtuals  
    virtual TBool DoHandleResponsePhaseL();
    virtual TBool DoHandleCompletingPhaseL();
    
    /*
    service a request at request phase
    */
    virtual void ServiceL() = 0;

private:
    void ExtractSessionTransactionId();                 
    
protected:
    MMTPDataProviderFramework&      iFramework;
    const TMTPTypeRequest*          iRequest;           //the pending request object.
    MMTPConnection&                 iConnection;        //the connection from which the request comes.
    TMTPTypeResponse                iResponse;          //the response object to send to the initiator.
    TBool                           iCancelled;         //indicates whether the data phase (send/receive) has been cancelled.
    TInt                            iElementCount;      //number of verification elements used for request checker.
    const TMTPRequestElementInfo*   iElements;          //pointer to an array of verification elements.
    TUint32                         iSessionId;         //session id for the pending request.
    TUint32                         iTransactionCode;   //transaction code for the pending request.

private:
    TMTPResponseCode                iResponseCode;      // contains response from CheckRequestL call.
    };

#endif // __CMTPEXAMPLEDPREQUESTPROCESSOR_H__

