// Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
// All rights reserved.
// This component and the accompanying materials are made available
// under the terms of "Eclipse Public License v1.0"
// which accompanies this distribution, and is available
// at the URL "http://www.eclipse.org/legal/epl-v10.html".
//
// Initial Contributors:
// Nokia Corporation - initial contribution.
//
// Contributors:
//
// Description:
//

#ifndef MTPDATAPROVIDERPLUGINEXAMPLE_H
#define MTPDATAPROVIDERPLUGINEXAMPLE_H

#include <mtp/cmtpdataproviderplugin.h>

// Forward declaration
class MMTPExampleDpRequestProcessor;
class CMTPObjectMetaData;

/** 
 Defines Example data provider plugin.
 */
class CMTPExampleDataProvider : 
	public CMTPDataProviderPlugin
    {
public:
    static TAny* NewL(TAny* aParams);
    virtual ~CMTPExampleDataProvider();
  
private:
	//from CMTPDataProviderPlugin
    void Cancel();
    void ProcessEventL(const TMTPTypeEvent& aEvent, MMTPConnection& aConnection);
    void ProcessNotificationL(TMTPNotification aNotification, const TAny* aParams);
    void ProcessRequestPhaseL(TMTPTransactionPhase aPhase, const TMTPTypeRequest& aRequest, MMTPConnection& aConnection);
    void SessionClosedL(const TMTPNotificationParamsSessionChange& aSession);
    void SessionOpenedL(const TMTPNotificationParamsSessionChange& aSession);
    void StartObjectEnumerationL(TUint32 aStorageId);
    void StartStorageEnumerationL();
    void Supported(TMTPSupportCategory aCategory, RArray<TUint>& aArray) const;
	void SupportedL(TMTPSupportCategory aCategory, CDesCArray& aStrings) const;

    TAny* GetExtendedInterface(TUid aInterfaceUid);
	 
private:
    CMTPExampleDataProvider(TAny* aParams);
	void ConstructL();

	TInt LocateRequestProcessorL(const TMTPTypeRequest& aRequest, MMTPConnection& aConnection);
	TInt LocateRequestProcessorL(const TMTPTypeEvent& aEvent, MMTPConnection& aConnection);	
					
private:
    
	RPointerArray<MMTPExampleDpRequestProcessor> iActiveProcessors;
	TInt					iActiveProcessor;
    TBool					iActiveProcessorRemoved; 
    };
 
#endif // MTPDATAPROVIDERPLUGINEXAMPLE_H
