// Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
// All rights reserved.
// This component and the accompanying materials are made available
// under the terms of "Eclipse Public License v1.0"
// which accompanies this distribution, and is available
// at the URL "http://www.eclipse.org/legal/epl-v10.html".
//
// Initial Contributors:
// Nokia Corporation - initial contribution.
//
// Contributors:
//
// Description:
//

#include <mtp/mtpprotocolconstants.h>
#include <mtp/tmtptyperequest.h>
#include <mtp/mmtpdataproviderframework.h>
#include <mtp/tmtptypeevent.h>
#include <mtp/mmtpconnection.h>
#include <mtp/mmtpobjectmgr.h>
 
#include "cmtpexampledprequestprocessor.h"


/**
 Standard c++ constructor
 @param aFramework	The data provider framework
 @param aConnection	The connection from which the request comes
 @param aElementCount Number of element in the request.
 @param aElements	The element info data.
 @return a pointer to the created request processor object
 */   
CMTPExampleDpRequestProcessor::CMTPExampleDpRequestProcessor(
											MMTPDataProviderFramework& aFramework,											
											MMTPConnection& aConnection,
											TInt aElementCount,
											const TMTPRequestElementInfo* aElements)
	:iFramework(aFramework),
	iConnection(aConnection),
	iElementCount(aElementCount),
	iElements(aElements)
	{
	
	}

/**
 Destructor
 */	
CMTPExampleDpRequestProcessor::~CMTPExampleDpRequestProcessor()
	{
	}
/**
 Release (delete) this request processor
 */  
 void CMTPExampleDpRequestProcessor::Release()
     {
     delete this;
    }


/**
 Send a response to the initiator
 @param aResponseCode The response code to send
 @param aParamCount	The number of parameters
 @param aParmas	The pointer to array of parameters
 */	
void CMTPExampleDpRequestProcessor::SendResponseL(TMTPResponseCode aResponseCode, TInt aParameterCount, TUint32* aParams)
	{   
	iResponse.SetUint16(TMTPTypeResponse::EResponseCode, aResponseCode);
		    
    iResponse.SetUint32(TMTPTypeResponse::EResponseSessionID, iSessionId);
	
	iResponse.SetUint32(TMTPTypeResponse::EResponseTransactionID, iTransactionCode);
   
    TInt i = 0;	
	for(i = 0; i < aParameterCount; i++)
		{
		iResponse.SetUint32(TMTPTypeResponse::EResponseParameter1 + i, aParams[i]);
		}

	i += TMTPTypeResponse::EResponseParameter1;
	while(i <= TMTPTypeResponse::EResponseParameter5)
	    {
	    iResponse.SetUint32(i, KMTPNotSpecified32);
	    i++;
	    }
	iFramework.SendResponseL(iResponse, *iRequest, iConnection);
	}
/**
 The current active request
 @return A reference to the current request
 */  
 const TMTPTypeRequest& CMTPExampleDpRequestProcessor::Request() const
     { 
     return *iRequest;
     }
     


/**
 Signal to the framework that the current request transaction has completed
 */
void CMTPExampleDpRequestProcessor::CompleteRequestL()
    {
	iFramework.TransactionCompleteL(*iRequest, iConnection);
	}


/**
 Handle the request
 @param aRequest	The request to be processed
 @param aPhase	The current transaction phase of the request
 @return ETrue if the transaction has completed, otherwise, EFalse
 */	
TBool CMTPExampleDpRequestProcessor::HandleRequestL(const TMTPTypeRequest& aRequest, TMTPTransactionPhase aPhase)
	{
	iRequest = &aRequest;
	TBool result = EFalse;
	switch(aPhase)
		{
		case ERequestPhase:		
		    ExtractSessionTransactionId();
		    ServiceL(); 
			break;

		case EResponsePhase:
			result = DoHandleResponsePhaseL();	
			break;
			
		case ECompletingPhase:
			result = DoHandleCompletingPhaseL();
			break;
		}
	return result;	
	}


/**
 The connection from which the current request comes
 @return A reference to the current connection
 */  
MMTPConnection& CMTPExampleDpRequestProcessor::Connection() const
     {
     return iConnection;
     }

/**
The Session ID from the current request
@return the value of the session ID
 */
TUint32 CMTPExampleDpRequestProcessor::SessionId()
    {
    return iSessionId;
    }
	
/**
 Handle the response phase of the current request
 @return EFalse
 */		
TBool CMTPExampleDpRequestProcessor::DoHandleResponsePhaseL()
	{
	TMTPResponseCode responseCode = (iCancelled ? EMTPRespCodeIncompleteTransfer : EMTPRespCodeOK);
	SendResponseL(responseCode);
	return EFalse;
	}

/**
 Handle the completing phase of the current request
 @return ETrue
 */		
TBool CMTPExampleDpRequestProcessor::DoHandleCompletingPhaseL()
	{
	CompleteRequestL();
	return ETrue;	
	}

/**
 Retrieve the session id and transaction code from the current request
 */
void CMTPExampleDpRequestProcessor::ExtractSessionTransactionId()
	{    
	iSessionId = iRequest->Uint32(TMTPTypeRequest::ERequestSessionID);    
	iTransactionCode = iRequest->Uint32(TMTPTypeRequest::ERequestTransactionID);		
	}


/**
 Check whether the processor can process the event
 @param aEvent The event to be processed
 @param aConnection The connection from which the request comes
 @return ETrue if the processor can process the request, otherwise EFalse
 */  
TBool CMTPExampleDpRequestProcessor::Match(const TMTPTypeEvent& aEvent, MMTPConnection& aConnection) const
    {

    TUint32 eventSessionId = aEvent.Uint32(TMTPTypeEvent::EEventSessionID);
    TUint32 eventTransactionCode = aEvent.Uint32(TMTPTypeEvent::EEventTransactionID);
    
    TBool result = EFalse;
    if(iSessionId == eventSessionId && 
        iTransactionCode == eventTransactionCode &&
        &iConnection == &aConnection)
        {
        result = ETrue;
        }
    return result;  
    }
 
/**
 Check whether the processor can process the request
 @param aRequest The request to be processed
 @param aConnection The connection from which the request comes
 @return ETrue if the processor can process the request, otherwise EFalse
 */  
TBool CMTPExampleDpRequestProcessor::Match(const TMTPTypeRequest& aRequest, MMTPConnection& aConnection) const
    {
    TBool result = ((&aRequest == iRequest) && (&iConnection == &aConnection));
    return result;      
    }
 
/**
 Handle the event
 @param aEvent The event to be processed
 */  
void CMTPExampleDpRequestProcessor::HandleEventL(const TMTPTypeEvent& aEvent)
      {
      TUint16 eventCode = aEvent.Uint16(TMTPTypeEvent::EEventCode);
      iCancelled = (eventCode == EMTPEventCodeCancelTransaction);
      }




