// Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
// All rights reserved.
// This component and the accompanying materials are made available
// under the terms of "Eclipse Public License v1.0"
// which accompanies this distribution, and is available
// at the URL "http://www.eclipse.org/legal/epl-v10.html".
//
// Initial Contributors:
// Nokia Corporation - initial contribution.
//
// Contributors:
//
// Description:
//


#include "cmtpexampledpvendordefinedop1.h"

/**
 Two-phase construction method
 
 @param aFramework   The data provider framework
 @param aConnection  The connection from which the request comes
 @return a pointer to the created request processor object
 */   
MMTPExampleDpRequestProcessor* CMTPExampleDpVendorDefinedOp1::NewL(MMTPDataProviderFramework& aFramework, MMTPConnection& aConnection)
    {
    CMTPExampleDpVendorDefinedOp1* self = new (ELeave) CMTPExampleDpVendorDefinedOp1(aFramework, aConnection);
    CleanupStack::PushL(self);
    self->ConstructL();
    CleanupStack::Pop(self);    
    return self;
    }


/**
 Destructor
 */  
CMTPExampleDpVendorDefinedOp1::~CMTPExampleDpVendorDefinedOp1()
    {   
   
    }

/**
 Standard c++ constructor
 */  
CMTPExampleDpVendorDefinedOp1::CMTPExampleDpVendorDefinedOp1(MMTPDataProviderFramework& aFramework, MMTPConnection& aConnection) :
    CMTPExampleDpRequestProcessor(aFramework, aConnection,  0, NULL)
    {
   
    }


/**
 Request handler for Example1 operation
 */   
void CMTPExampleDpVendorDefinedOp1::ServiceL()
    {   
    SendResponseL(EMTPRespCodeOK);
    }


/**
 Second phase constructor
 */
void CMTPExampleDpVendorDefinedOp1::ConstructL()
    {

    }


