// Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
// All rights reserved.
// This component and the accompanying materials are made available
// under the terms of "Eclipse Public License v1.0"
// which accompanies this distribution, and is available
// at the URL "http://www.eclipse.org/legal/epl-v10.html".
//
// Initial Contributors:
// Nokia Corporation - initial contribution.
//
// Contributors:
//
// Description:
//

#include <bautils.h>
#include <mtp/mmtpconnection.h>
#include <mtp/mtpprotocolconstants.h>
#include <mtp/mmtpdataproviderframework.h>
#include <mtp/mmtpstoragemgr.h>
#include <mtp/cmtpobjectmetadata.h>
#include <mtp/mmtpobjectmgr.h>

#include "mtpdataproviderpluginexample.h"

#include "mtpexamplerequestprocessor.h"
#include "cmtpexampledprequestprocessor.h"

#include "cmtpexampledpconst.h"


// Class constants.
/** Defines the number of MTP Active Processors allowed */
static const TInt KMTPExampleDpSessionGranualrity = 3;


/**
 Two Phase Construction
 @param aParams	pointer to MMTPDataProviderFramework
 */
TAny* CMTPExampleDataProvider::NewL(TAny* aParams)
	{
	CMTPExampleDataProvider* self = new (ELeave) CMTPExampleDataProvider(aParams);
	CleanupStack::PushL(self);
	self->ConstructL();
	CleanupStack::Pop(self);
	return self;
	}
	
/**
 Standard C++ constructor
 @param aParams	pointer to MMTPDataProviderFramework
 */
CMTPExampleDataProvider::CMTPExampleDataProvider(TAny* aParams)
	:CMTPDataProviderPlugin(aParams),
	iActiveProcessors(KMTPExampleDpSessionGranualrity),
    iActiveProcessor(-1)
	{
	
	}

/**
 Destructor
 */
CMTPExampleDataProvider::~CMTPExampleDataProvider()
	{
    TUint count(iActiveProcessors.Count());
    while (count--)
        {
        iActiveProcessors[count]->Release();
        }
    iActiveProcessors.Close();
	}
	

void CMTPExampleDataProvider::Cancel()
	{
	}

/**
 Defines the supported operations and formats of the example data provider.
 @param aCategory Defines what MTP is quering the DP about
 @param aArray Supported() edits array to append supported features
 */
void CMTPExampleDataProvider::Supported(TMTPSupportCategory aCategory, RArray<TUint>& aArray) const
    {
    switch (aCategory) 
        {        
        case EEvents:
            break;
        case EObjectPlaybackFormats:
        case EObjectCaptureFormats:
            break;
        case EObjectProperties:
            break; 
    
        case EOperations:
            {
            TInt count(sizeof(KMTPExampleDpSupportedOperations) / sizeof(KMTPExampleDpSupportedOperations[0]));
            for (TInt i(0); (i < count); i++)
                {
                aArray.Append(KMTPExampleDpSupportedOperations[i]);
                }   
            }
            break;  
   
        default:   
            break;
        }
    }
/**
 Defines the supported vendor extension info of the example data provider.
 
 @param aCategory Defines what MTP is quering the DP about
 @param aStrings Supported() edits array to append supported vendor info 
 */
void CMTPExampleDataProvider::SupportedL(TMTPSupportCategory aCategory, CDesCArray& /*aStrings*/) const
	{
	switch (aCategory) 
        {
        case EFolderExclusionSets:
            break;
        case EFormatExtensionSets:
            break;
        default:
            break;
        }
	}

/**
 Starts the enumeration of the example dp, just declare as complete.
 */
void CMTPExampleDataProvider::StartObjectEnumerationL(TUint32 aStorageId)
    {
    Framework().ObjectEnumerationCompleteL(aStorageId);

    }
    
/**
 Starts the enumeration of the example dp storage, just declare as complete.
 */
void CMTPExampleDataProvider::StartStorageEnumerationL()
    {
    Framework().StorageEnumerationCompleteL();
    }

/**
 Process the event from initiator.
 @param aEvent	The event to be processed
 @param aConnection	The connection from which the event comes
 */
void CMTPExampleDataProvider::ProcessEventL(const TMTPTypeEvent& aEvent, MMTPConnection& aConnection)	
	{
    TInt idx = LocateRequestProcessorL(aEvent, aConnection);

    if (idx != KErrNotFound)
        {
        iActiveProcessors[idx]->HandleEventL(aEvent);
        }
	}

/**
 Process the notification from framework.
 @param aNotification  The notification to be processed
 @param aParams        Notification parmenter
 */
void CMTPExampleDataProvider::ProcessNotificationL(TMTPNotification aNotification, const TAny* aParams)
    {
    switch (aNotification)
        {
    case EMTPSessionClosed:
        SessionClosedL(*reinterpret_cast<const TMTPNotificationParamsSessionChange*>(aParams));
        break;
        
    case EMTPSessionOpened:
        SessionOpenedL(*reinterpret_cast<const TMTPNotificationParamsSessionChange*>(aParams));
        break;
        
    default:
        // Ignore all other notifications.
        break;
        }
    }
    
/**
 Process the request from initiator.
 @param aPhase	The request transaction phase
 @param aRequest	The request to be processed
 @param aConnection	The connection from which the request comes
 */	
void CMTPExampleDataProvider::ProcessRequestPhaseL(TMTPTransactionPhase aPhase, const TMTPTypeRequest& aRequest, MMTPConnection& aConnection)
	{
    //Check if the request is handled.
    TInt idx(LocateRequestProcessorL(aRequest, aConnection));
    MMTPExampleDpRequestProcessor* processor(iActiveProcessors[idx]);
    //Handle the request
    TBool result(processor->HandleRequestL(aRequest, aPhase));
    if (result)    //destroy the processor
        {
        processor->Release();
        iActiveProcessors.Remove(idx);
        }
	}

/**
 Notify the data provider that the session has been closed
 @param aSessionId	The session Id closed
 @param aConnection	The connection of the sesssion
 */
void CMTPExampleDataProvider::SessionClosedL(const TMTPNotificationParamsSessionChange& aSession)	
	{
    TInt count = iActiveProcessors.Count();
    while(count--)
        {
        MMTPExampleDpRequestProcessor* processor = iActiveProcessors[count];
        TUint32 sessionId = processor->SessionId();
        if((sessionId == aSession.iMTPId) && (processor->Connection().ConnectionId() == aSession.iConnection.ConnectionId()))
            {
            iActiveProcessors.Remove(count);
            if (count == iActiveProcessor)
                {
                iActiveProcessorRemoved = ETrue;
                }
            else
                {
                processor->Release();
                }
            }
        } 
	}

/**
 Notify the data provider that the session opened.
 @param aSessionId	The session Id opened
 @param aConnection	The connection of the sesssion
 */
void CMTPExampleDataProvider::SessionOpenedL(const TMTPNotificationParamsSessionChange& /*aSession*/)	
	{
	}
	
/**
 Get the pointer to the extended interface.
 @param aInterfaceUid	The uid of the extended interface
 @return the pointer to the extended interface
 */
TAny* CMTPExampleDataProvider::GetExtendedInterface(TUid /*aInterfaceUid*/)	
	{
	return NULL;
	}

/**
 Second-phase construction
 */
void CMTPExampleDataProvider::ConstructL()	
	{

      
	}

/**
 Find or create a request processor that can process the request.
 @param aRequest	The request to be processed
 @param aConnection The connection from which the request comes

 @return the index of the found/created request processor
 */
TInt CMTPExampleDataProvider::LocateRequestProcessorL(const TMTPTypeRequest& aRequest, MMTPConnection& aConnection)
	{
    TInt idx(KErrNotFound);
    //Get the Count of the request supported.
    TInt count(iActiveProcessors.Count());
    //Not found create and then append to the array.
    if (idx == KErrNotFound)
        {
        MMTPExampleDpRequestProcessor* processor = MTPExampleDpProcessor::CreateL
                                                 (Framework(), aRequest, aConnection);
        CleanupReleasePushL(*processor);
        iActiveProcessors.AppendL(processor);
        CleanupStack::Pop(processor);
        idx = count;
        }
    return idx;
	}

/**
 Find or create a request processor that can process the event.

 @param aEvent	The event to be processed
 @param aConnection The connection from which the request comes

 @return the index of the found/created request processor
 */
TInt CMTPExampleDataProvider::LocateRequestProcessorL(const TMTPTypeEvent& aEvent, MMTPConnection& aConnection)
	{
    TInt idx(KErrNotFound);
    TInt count(iActiveProcessors.Count());
    for (TInt i(0); (i < count); i++)
        {
        if (iActiveProcessors[i]->Match(aEvent, aConnection))
            {
            idx = i;
            break;
            }
        }    
    return idx;   
	}
	
	

