// Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
// All rights reserved.
// This component and the accompanying materials are made available
// under the terms of "Eclipse Public License v1.0"
// which accompanies this distribution, and is available
// at the URL "http://www.eclipse.org/legal/epl-v10.html".
//
// Initial Contributors:
// Nokia Corporation - initial contribution.
//
// Contributors:
//
// Description:
// 
//

#include <mtp/tmtptyperequest.h>

#include "mtpexamplerequestprocessor.h"
#include "cmtpexampledprequestprocessor.h"
#include "cmtpexampledpvendordefinedop1.h"
#include "cmtpexampledpvendordefinedop2.h"
#include "cmtprequestunknown.h"
#include "cmtpexampledpconst.h"

/**
 A mapping table from the operation code to the request processor factory method.
 */
static const TMTPRequestProcessorEntry KMTPExampleDpRequestProcessorTable[] = 
    {
        {EMTPOpVendorDefined1, CMTPExampleDpVendorDefinedOp1::NewL},
        {EMTPOpVendorDefined2 , CMTPExampleDpVendorDefinedOp2::NewL},
        {EMTPOpCodeSkip, CMTPExampleDpVendorDefinedOp2::NewL},
    };

/**
 Create a request processor that matches the request.
 @param aPlugin  The reference to the data provider plugin 
 @param aFramework The reference to the data provider framework
 @param aRequest The request to be processed
 @param aConnection The connection from which the request comes from
 @return a pointer to the request processor
 */  
MMTPExampleDpRequestProcessor* MTPExampleDpProcessor::CreateL(
                                                    MMTPDataProviderFramework& aFramework,
                                                    const TMTPTypeRequest& aRequest, 
                                                    MMTPConnection& aConnection)
    {
    TMTPRequestProcessorCreateFunc createFunc = NULL; 
    TUint16 operationCode = aRequest.Uint16(TMTPTypeRequest::ERequestOperationCode);
    TInt count = sizeof(KMTPExampleDpRequestProcessorTable) / sizeof(TMTPRequestProcessorEntry);
    for(TInt i = 0; i < count; i++)
        {
        if(KMTPExampleDpRequestProcessorTable[i].iOperationCode == operationCode)
            {
            createFunc = KMTPExampleDpRequestProcessorTable[i].iCreateFunc;
            break;
            }
        }
        
    if(!createFunc) 
        {
        createFunc = CMTPRequestUnknown::NewL;
        }
        
    return (*createFunc)(aFramework, aConnection);
    }
    


