// Copyright (c) 2008-2009 Nokia Corporation and/or its subsidiary(-ies).
// All rights reserved.
// This component and the accompanying materials are made available
// under the terms of "Eclipse Public License v1.0"
// which accompanies this distribution, and is available
// at the URL "http://www.eclipse.org/legal/epl-v10.html".
//
// Initial Contributors:
// Nokia Corporation - initial contribution.
//
// Contributors:
//
// Description:
// Contains the definition of the CSemaphoreExample class.
//


#ifndef CSEMAPHOREEXAMPLE_H_
#define CSEMAPHOREEXAMPLE_H_

#include "CDatabase.h"

/**
This class is the main class which starts the application, and starts
two threads to read to/write from a database. 
*/
class CSemaphoreExample : public CBase
    {
public:
    virtual ~CSemaphoreExample();  
    static CSemaphoreExample* NewL();
    
    static TInt ReadThreadFuncL(TAny* aPtr);

    static TInt WriteThreadFuncL(TAny* aPtr);
    
    void StartThreads(); 
    
    void PrintMessage(); 
 
protected: 
    void ConstructL();
	
private: 
    //Thread to read data from database.
    RThread iReadThread;
    //Thread to write data in the database.
    RThread iWriteThread;
    
    CConsoleBase* iConsole; 
    
    #ifdef USE_SEMAPHORE
    RSemaphore iSem; 
    #endif
    };

#endif /*CSEMPAHOREEXAMPLE_H_*/
