// Copyright (c) 2008-2009 Nokia Corporation and/or its subsidiary(-ies).
// All rights reserved.
// This component and the accompanying materials are made available
// under the terms of "Eclipse Public License v1.0"
// which accompanies this distribution, and is available
// at the URL "http://www.eclipse.org/legal/epl-v10.html".
//
// Initial Contributors:
// Nokia Corporation - initial contribution.
//
// Contributors:
//
// Description:
//

#ifndef __RBUFEXAMPLE_H__
#define __RBUFEXAMPLE_H__

#include <e32cons.h>
#include <f32file.h>
#include <s32file.h> 

/**
This class demonstrates:
 - creating an empty RBuf,
 - creating an RBuf containing a copy of an existing descriptor,
 - assigning a descriptor to an RBuf,
 - assigning memory to an RBuf,
 - reallocating and freeing the memory,
 - cleaning up an RBuf,
 - replacing and modifying the data held in the RBuf.
*/

class CRBufExample: public CBase
	{
	public:
	static CRBufExample* NewL();
	~CRBufExample();
 	
 	void CreateRBufL();
 	void CreateRBufFromExistingDesL();
 	void CreateRBufFromHBufCL();
 	void CreateRBufFromAllocatedMemoryL();
 	void CreateRBufFromAnotherRBufL();
 	void CreateRBufUsingRReadStreamL();
 	void SwapTwoRBufsL();
 	void CopyDataUsingAssignmentOperatorL();
 	void ReallocateAndFreeTheMemoryBufferL();
 	void ReplaceAndModifyTheDataL();
 	void CleanUpRulesL();

	private:
	CRBufExample();
	void ConstructL();

	private:
	/** Pointer to console interface */
	CConsoleBase* iConsole;	
	};

#endif //__RBUFEXAMPLE_H__



