// fileaccessexample.c
//
// Copyright (c) 2007-2009 Nokia Corporation and/or its subsidiary(-ies).
// All rights reserved.
// This component and the accompanying materials are made available
// under the terms of "Eclipse Public License v1.0"
// which accompanies this distribution, and is available
// at the URL "http://www.eclipse.org/legal/epl-v10.html".
//
// Initial Contributors:
// Nokia Corporation - initial contribution.
//
// Contributors:
//
// Description:
// Component description file
//

// This example demonstrates the Symbian platform Platform Security model.
// This shows the restrictions on the directories that can be accessed by a program, 
// depending on the capabilities that the program has.

// Include files
#include <stdio.h>
#include <errno.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/stat.h>

/**
Waits for any key press 
*/
void PressAKey()
	{
	fflush(stdout);
	getchar();
	}
/**
Reports any error with error number.
@return EXIT_FAILURE Returns the failure code.
*/
int DisplayErrorMessage(char msg[])
	{
	printf("%s [Error NUMBER = %d]\n",msg,errno);
	PressAKey();
	return EXIT_FAILURE;
	}
/**
Create a secure directory for the program in the working directory of the process.
This is C:\private\<process UID>.
*/
void CreateASecureDirectory()
	{
	int result;
	
	/** 
	Call mkdir() function to create a directory named mydirectory in the working directory.
	It takes two parameters such as the name of the directory and mode to create it.
	This returns the value 0 if successful; otherwise the value -1 is returned.
	*/ 
	result = mkdir("mydirectory",S_IWUSR);	   
	if(result == 0)
		{
		printf(" A secure directory for the program is created successfully\n");
		PressAKey();
		}
	else
		{
		DisplayErrorMessage("\nError in creating directory\n");
		PressAKey();
		}
	}
/**
Write data to a file in the created directory.
@param FileName Path of the file to write to.
*/
void WriteDataToAFile(char FileName[])
	{
	FILE* fp= NULL;
	
	/**
	Call fopen() function to open the file.
	It takes two parameters, a string containing the file path, and the mode, set to 'w' to write data to it.
	It returns a file pointer if successful, otherwise NULL is returned.
	*/
	fp = fopen(FileName, "w");
	if (fp== NULL)
		{
		DisplayErrorMessage("\nError in writing data in to the file=%d");
		PressAKey();
		}
	else
		{
		fprintf(fp,"%s","hello");
		fflush(fp);
		fclose(fp);
		printf(" Writing data in to the file from the secure directory is successful");
		}
	}

/**
Read data from a file in the created directory.
@param FileName Path of the file to read data from.
*/
void ReadDataFromAFile(char FileName[])
	{
	FILE* fp= NULL;
	
	/**
	Call fopen() function to open the file.
	It takes two parameters, a string containing the file path, and the mode, set to 'r' to read data from it.
	It returns a file pointer if successful, otherwise NULL is returned.
	*/
	fp = fopen(FileName, "r");
	if (fp == NULL)
		{
       	DisplayErrorMessage("\nError in reading data from the file = %d"); 
    	printf(" Press any key to exit from the example");
      	PressAKey();
		}
	else
		{
		char x[30];
				
		// Seek to the beginning of the file
     	fseek(fp, SEEK_SET, 0); 
     	
     	// Get the data present in file from the beginning 
		fscanf(fp,"%s",x);
		printf("\n Data present in the file is : %s",x);
		fclose(fp);
		printf("\n Reading data of the file from the directory is successful\n");
		}
	}
/**
Remove the secure directory.
@param FileName Path of the file present in the directory.
*/
void RemoveADirectory(char FileName[])
	{
	int result;
	
	/**
	Call remove() function to remove the file specified in the path.
	It takes the parameter of a string containing the path of the file to remove.
	This returns the value 0 if successful; otherwise the value -1 is returned. 
	*/
	result = remove(FileName);
	if(result == 0)
			{
			printf(" Removing the file from the directory is successful\n");
			}
		else
			{
			DisplayErrorMessage(" Error in removing the file from the directory=%d");
			PressAKey();
			}
	/**
	Call rmdir() function to remove a empty directory named mydirectory.
	Its parameter is the name of the directory to remove
	This returns the value 0 if successful; otherwise the value -1 is returned.
	*/
	result = rmdir("mydirectory");
   
	if(result == 0)
		{
		printf(" Removing the the directory is successful\n");
		PressAKey();
		}
	else
		{
		DisplayErrorMessage(" Error in removing the directory=%d");
		PressAKey();
		}
	}
/**
Write data to a file in another program's private directory.
@param FileName Path of the file to write data to
*/
void WriteDataToFileOfAnotherProgram(char FileName[])
	{
	FILE* fp= NULL;
	
	/**
	Call fopen() function to open the file.
	It takes two parameters, a string containing the file path, and the mode, set to 'w' to write data to it.
	It returns a file pointer if successful, otherwise NULL is returned.
	*/
	fp = fopen(FileName, "w");
	
	if (fp == NULL)
		{
		printf(" Writing data to files in a private directory belonging to another program is not possible"); 
      	}
	else
		{
		printf("\n Writing data to files in a private directory belonging to another program is possible"); 
		PressAKey();
		}
	}
/**
Read data from a file in another program's private directory.
@param FileName Path of the file to read data from.
*/
void ReadDataFromFileOfAnotherProgram(char FileName[])
	{
	FILE* fp= NULL;
	
	/**
	Call fopen() function to open the file.
	It takes two parameters, a string containing the file path, and the mode, set to 'r' to read data from it
	It returns a file pointer if successful, otherwise NULL is returned.	
	*/
	fp = fopen(FileName, "r");
	
	if (fp == NULL)
		{
		printf("\n Reading data from files in a private directory belonging to another program is not possible"); 
 		PressAKey();
		}
	else
		{
   		printf("\n Reading data from files in a private directory belonging to another program is possible"); 
		PressAKey(); 
		}
	}
/**
Write data to a file in the sys/bin directory.
@param FileName Path of the file to write data to.
*/
void WriteDataToFileOfSysBin(char FileName[])
	{
	FILE* fp= NULL;
	
	/**
	Call fopen() function to open the file.
	It takes two parameters, a string containing the file path, and the mode, set to 'w' to write data to it.
	It returns a file pointer if successful, otherwise NULL is returned.
	*/
	fp = fopen(FileName, "w");
	
	if (fp == NULL)
		{
		printf("\n Writing data to files in the sys/bin directory is not possible"); 
		}
	else
		{
		printf("\n Writing data to files in the sys/bin directory is possible"); 
		PressAKey();
		}
	}
/**
Read data from a file in the sys/bin directory.
@param FileName Path of the file to read data from.
*/
void ReadDataToFileOfSysBin(char FileName[])
	{
	FILE* fp = NULL;
	
	/**
	Call fopen() function to open the file.
	It takes two parameters, a string containing the file path, and the mode, set to 'r' to read data from it.
	It returns a file pointer if successful, otherwise NULL is returned.
	*/
	fp = fopen(FileName, "r");
	
	if (fp == NULL)
		{
		printf("\n Reading data from files in the sys/bin directory is not possible"); 
 		PressAKey();
		}
	else
		{
   		printf("\n Reading data from files in the sys/bin directory is possible"); 
   		printf(" Press any key to exit from the example");
		PressAKey(); 
		}	
	}

int main()
{
	char ownFileName[50] = "\\private\\e80000c9\\mydirectory\\myownfile.txt";
	char otherFileName[40] = "\\private\\e80000c8\\otherfile.txt";
	char sysBinFileName[30] = "\\sys\\bin\\euser.dll";
	
	printf("\n Welcome to the file access example using POSIX APIs\n");
	
	// Print the message to start the example application.
	printf("\n Press enter key to step through the example\n");
	PressAKey();
	
	// Call CreateASecureDirectory() function to create a secure directory for the program.
	CreateASecureDirectory();
	
	// Call WriteDataToAFile() function to write data in to a file from the created directory.
	WriteDataToAFile(ownFileName);
	
	// Call WriteDataToAFile() function to write data in to a file from the created directory.
	ReadDataFromAFile(ownFileName);
	
	// Call RemoveADirectory() function to remove the directory.
	RemoveADirectory(ownFileName);
	
	// Call WriteDataToFileOfAnotherProgram() function to write data in to a file of another program.
	WriteDataToFileOfAnotherProgram(otherFileName);
	
	// Call ReadDataFromFileOfAnotherProgram() function to read data from a file of another program.
	ReadDataFromFileOfAnotherProgram(otherFileName);
	
	// Call WriteDataToFileOfSysBin() function to write data in to a file of sys/bin directory.
	WriteDataToFileOfSysBin(sysBinFileName);
	
	// Call ReadDataFromFileOfSysBin() function to read data from a file in the sys/bin directory.
	ReadDataToFileOfSysBin(sysBinFileName);
	
	// Print the message to exit from the example application.
	printf("\n Press enter key to exit from the example application");
	PressAKey();
	
	// returns the success code.
	return EXIT_SUCCESS;
}


