/*
 * Copyright  2009 Nokia Corporation.
 */

#ifndef BLUETOOTHPMPEXAMPLEAPPUI_H
#define BLUETOOTHPMPEXAMPLEAPPUI_H

// INCLUDES
#include <eikapp.h>
#include <eikdoc.h>
#include <e32std.h>
#include <coeccntx.h>
#include <aknappui.h>

_LIT(KMsgSendFailed, "Can't send msg");
_LIT(KInfo, "Bluetooth PMP example\n");

// FORWARD DECLARATIONS
class CBluetoothPMPExampleEngine;
class CBluetoothPMPExampleRTEContainer;

// CLASS DECLARATION

/**
* Application UI class.
* Provides support for the following features:
* - EIKON control architecture
*
*/
class CBluetoothPMPExampleAppUi : public CAknAppUi
    {
    public: // // Constructors and destructor

        /**
        * EPOC default constructor.
        */
        void ConstructL();

        /**
        * Destructor.
        */
        ~CBluetoothPMPExampleAppUi();

    public: // New functions
    
        CBluetoothPMPExampleRTEContainer* Container();  
        void ResetUiL();

    public: // Functions from base classes
        /**
        *  from CAknAppUiBase
        */
        void HandleResourceChangeL(TInt aType);

    private:
        // From MEikMenuObserver
        void DynInitMenuPaneL(TInt aResourceId,CEikMenuPane* aMenuPane);

    private:
        /**
        * From CEikAppUi, takes care of command handling.
        * @param aCommand command to be handled
        */
        void HandleCommandL(TInt aCommand);

        /**
        * From CEikAppUi, handles key events.
        * @param aKeyEvent Event to handled.
        * @param aType Type of the key event.
        * @return Response code (EKeyWasConsumed, EKeyWasNotConsumed).
        */
        virtual TKeyResponse HandleKeyEventL(
            const TKeyEvent& aKeyEvent,TEventCode aType);

    private:    // data
        CBluetoothPMPExampleEngine* iEngine;
        CBluetoothPMPExampleRTEContainer* iContainer;


    };

#endif

// End of File
