/*
 * Copyright  2009 Nokia Corporation.
 */

#ifndef BLUETOOTHPMPEXAMPLEENGINE_H
#define BLUETOOTHPMPEXAMPLEENGINE_H

// INCLUDES
#include <e32base.h>
#include <aknviewappui.h>

#include <coecntrl.h>
#include <es_sock.h>
#include <btdevice.h>
#include <bt_sock.h>
#include <btsdp.h>
#include <btmanclient.h>

#ifdef ENABLE_LIAC
#include <e32property.h>
#endif

#include "BluetoothPMPExample.hrh"
#include "BluetoothPMPExampleRTEContainer.h"
#include "BluetoothPMPExampleAppUi.h"

#include "Common.h"
#include "DeviceDiscoverer.h"
#include "ServiceDiscoverer.h"
#include "Listener.h"
#include "Connector.h"

// maximum number of bluetooth device connections
const TInt KMaxConnectedDevices=7;

// length of label message buffer
const TInt KMsgLength = 384;

//avoiding magic numbers ;)
const TInt KThirty = 30;
const TInt KTwenty = 20;
const TInt KEighty = 80;
const TInt KTwelve = 12;
const TInt KForty = 40;

//the text displayed for devices with no name
_LIT(KDeviceWithNoName,"*Jane Doe*");
_LIT(KNoServiceFound,"No services found!\n");
_LIT(KNewLine,"\n");
_LIT(KServiceFound,"Found service on:\n");
_LIT(KNoDevFound,"\nNo devices found!");
_LIT(KDevices," devices.");
_LIT(KFoundTxt,"Found ");
_LIT(KSecTxt," s.");
_LIT(KTimeTxt,"time ");
_LIT(KFormatStr,"< %S: %S\n");
_LIT(KDisconMsg,"Disconnected!\nSlave stopped.\n");
_LIT(KDeviceDisconMsg,"%S disconnected!\n");
_LIT(KConnMsg,"Connected!\n");
_LIT(KFormatStr1,"< %S\n");
_LIT(KFormatStr2,"> %S: %S\n");
_LIT(KFormatStr3,"> %S\n");
_LIT(KMessage,"message");
_LIT(KNoConns,"No connections!");
_LIT(KConnDevicesTxt,"Connected devices:\n");
_LIT(KConnectingTxt, "Connecting...\n");
_LIT(KDisconnDevicesTxt, "Devices disconnected\n");
_LIT(KSlaveInitCompTxt,"\nSlave init complete!\nWaiting for connection.");
_LIT(KListeningTxt,"\nListening channel %d");
_LIT(KSlaveInitTxt,"Slave init..");
_LIT(KDiscServicesTxt,"Discovering services,\nplease wait...\n");
_LIT(KDiscDevicesTxt,"Discovering devices,\nplease wait...\n");

_LIT(KServiceDiscoveryError, "Serv disco error:");
_LIT(KTurningOn, "Turning bt on");

_LIT(KLIACError, "There was an erron on setting LIAC status: %d" );
_LIT(KLIACOn, "LIAC has been enabled" );
_LIT(KLIACOff, "LIAC has been disabled" );


// FORWARD DECLARATIONS
class CBluetoothPMPExampleContainer;
class CDeviceDiscoverer;
class CServiceAdvertiser;
class CServiceDiscoverer;
class CListener;
class CConnector;


// CLASS DECLARATION

/**
*  CBluetoothPMPExampleEngine application engine class.
*
*/
class CBluetoothPMPExampleEngine : public CBase,
                                   public MListenerObserver,
                                   public MConnectorObserver,
                                   public MDeviceDiscoObserver,
                                   public MServiceDiscoObserver
{
public:

/*!
 * NewL()
 *
 * discussion Create new CBluetoothPMPExampleEngine object
 * return a pointer to the created instance of CBluetoothPMPExampleEngine
 */
    static CBluetoothPMPExampleEngine* NewL(
        CBluetoothPMPExampleAppUi& /* aAppUi */);

/*!
 * NewLC()
 *
 */
    static CBluetoothPMPExampleEngine* NewLC(
        CBluetoothPMPExampleAppUi& /* aAppUi */);

/*!
 * ~CBluetoothPMPExampleContainer()
 *
 * discussion Destroy the object and release all memory objects
 */
    ~CBluetoothPMPExampleEngine();

public: // New functions

/*!
 * DiscoverDevicesL()
 *
 * discussion Discovers bluetooth devices within range.  the discovered
 * devices will be displayed to user.
 */
    void DiscoverDevicesL();

/*!
 * StartServiceDiscovery()
 *
 * discussion Starts service discovery for services on remote devices.
 */
    void DiscoverServicesL();

/*!
 * StartSlaveL()
 *
 * discussion Starts the application in slave more.  the application will open
 * listening socket to listen to incoming connection request, and advertise
 * its services.
 */
    void StartSlaveL();

    void StopSlaveL();
    
/*!
 * SendMessageL()
 *
 * discussion Send a message to all connected slaves.  the user will be
 * prompted to enter the message text he/she wishes to send.
 */
    void SendMessageL();

/*!
 * ConnectDevicesL()
 *
 * discussion Connects to the remote devices that were discovered to offer
 * the service we require.
 */
    void ConnectDevicesL();

/*!
 * DisconnectDevices()
 *
 * discussion Disconnects from connected remote devices.
 */
    void DisconnectDevices();

/*!
 * ShowConnectedDevicesL()
 *
 * discussion Displays the connected remote devices.
 */
    void ShowConnectedDevicesL();

/*!
 * HandleListenerDataReceivedL()
 *
 * discussion Handles the data slave received from a master.
 *
 * param aData the data received.
 */
    void HandleListenerDataReceivedL(const TDesC& aData);

/*!
 * HandleConnectedDataReceivedL()
 *
 * discussion Handles the data a master received from a slave.
 *
 * param aName the name of the slave that sent the data.
 * param aData the data received.
 */
    void HandleConnectorDataReceivedL(THostName aName, const TDesC& aData);
    void HandleConnectorErrorL(THostName aName, TInt aError);
/*!
 * HandleListenerConnectedL()
 *
 * discussion Handles the event of slave connection (slave was connected to
 * by master).  user will be notified of connection.
 */
    void HandleListenerConnectedL();

/*!
 * HandleListenerDisconnectedL()
 *
 * discussion Handles the event of slave disconnection, the master connection
 * to slave was terminated.  user will be notitied of disconnection.
 */
    void HandleListenerDisconnectedL();

/*!
 * HandleDeviceDiscoveryComplete()
 *
 * discussion Handles the event of device discovery completion.  the
 * discovered devices will be displayed to user.
 */
    void HandleDeviceDiscoveryComplete(TInt aError);

    /*
    * From MDeviceDiscoObserver
    */
    void DeviceDiscovered(const TDeviceData &aDevice);

/*!
 * HandleServiceDiscoveryCompleteL()
 *
 * discussion Handles the event of service discovery completion.  the
 * discovered services will be displayed to user.
 */
    void HandleServiceDiscoveryCompleteL();

/*!
 * ReportServiceDiscoveryErrorL()
 *
 * discussion An error has occured during service discovery
 */
    void ReportServiceDiscoveryErrorL(TInt aError);

/*!
 * HasConnection()
 *
 * discussion Returns true if master has any slave connections.
 */
    TBool HasConnections();

/*
 * TurnBtOnL()
 * 
 * discussion
 * Uses the Notifier API to ask the user to turn on Bluetooth
 * if it's not on already.
 * HasConnection()
 *
 * 
 */
    void TurnBtOnL();

#ifdef ENABLE_LIAC
/*!
 * SetLIAC()
 * 
 * discussion
 * Set LimitedDiscoverableStatus status
 * 
 */
    void SetLIAC( TBool aState );

/*!
 * LIAC()
 * 
 * discussion
 * It returns LimitedDiscoverableStatus status
 * 
 */
    TBool LIAC();
#endif

/*!
 * IsDiscoveryActive()
 * 
 * discussion
 * It returns ETrue if there is an ongoing device discovery
 * 
 */
    TBool IsDiscoveryActive();

/*!
 * StopDiscovery()
 * 
 * discussion
 * It stops device discovery if there is any ongoing
 * 
 */
    void StopDiscovery();

private: // in-class methods

/*!
 * ShowMessageL()
 *
 * discussion Displays application messages for user on a label
 *
 * param aMsg text to be displayed
 * param aDrawLine if true draws a line

 */
    void ShowMessageL(const TDesC& /* aMsg */, TBool /* aDrawLine=EFalse */);


private: // Basic two-phase EPOC constructors

/*!
 * ConstructL()
 *
 */
    void ConstructL();

/*!
 * CBluetoothPMPExampleContainer()
 *
 * discussion Perform the first phase of two phase construction
 */
    CBluetoothPMPExampleEngine(CBluetoothPMPExampleAppUi& /* aAppUi */);


public:     // data members

    // listener
    CListener* iListener;
    // device discoverer
    CDeviceDiscoverer* iDeviceDiscoverer;
    // service advertiser
    CServiceAdvertiser* iServiceAdvertiser;
    // service discoverer
    CServiceDiscoverer* iServiceDiscoverer;
    // true if the application is acting as a slave
    TBool iIsSlave;
    // true if the application is acting as a master
    TBool iIsMaster;

private:    // data members

    // application UI object reference
    CBluetoothPMPExampleAppUi& iAppUi;
    // socket server
    RSocketServ iSocketServ;
    // array holding the connectors
    TFixedArray<CConnector* ,KMaxConnectedDevices> iConnectedDevices;
    
    // device data list reference
    TDeviceDataList iDevDataList;
    // number of slave connections master has
    TInt iConnectedDeviceCount;
    //for timing device disco:
    TTime iStartTime;
    TTime iEndTime;
    
    TBuf<KTwenty> iMsgtext;
    TBuf8<KTwenty> iMsgtext8;


#ifdef ENABLE_LIAC
    //property for LimitedDiscoverableStatus
    RProperty   iProperty;

    //flag if LimitedDiscoverableStatus is enabled
    TBool iLIAC;
#endif

};

#endif

// End of File
