/*
 * Copyright  2009 Nokia Corporation.
 */

#ifndef BLUETOOTH_EXAMPLE_RTE_CONTAINER_H
#define BLUETOOTH_EXAMPLE_RTE_CONTAINER_H

// INCLUDES
#include <coecntrl.h>

// FORWARD DECLARATIONS
class CRichTextEditorRTE;

// CLASS DECLARATION

/**
*  CBluetoothPMPExampleRTEContainer Container control class.
*
*/
class CBluetoothPMPExampleRTEContainer : public CCoeControl
    {
    public: // Constructors and destructor

        /**
        * Create new CBluetoothPMPExampleRTEContainer object
        *
        * @param aRect Frame rectangle for container.
        * @return a pointer to the created instance of CBluetoothPMPExampleRTEContainer.
        */
        static CBluetoothPMPExampleRTEContainer* NewL(const TRect& aRect);

        /**
        * NewLC
        */
        static CBluetoothPMPExampleRTEContainer* NewLC(const TRect& aRect);

        /**
        * Symbian OS default constructor.
        * @param aRect Frame rectangle for container.
        */
        void ConstructL(const TRect& aRect);

        /**
        * Destructor.
        */
        ~CBluetoothPMPExampleRTEContainer();

    public: // New functions

        /**
        * Print text on the screen.
        * @param aText text to be displayed.
        */
        void DrawTextL( const TDesC& aText );

        /**
        * Print text on the screen. No Carriage return at the end.
        * @param aText text to be displayed.
        */
        void DrawTextWithoutCarriageL( const TDesC& aText );

        /**
        * Print underlined text on the screen.
        * @param aText text to be displayed.
        */
        void DrawUnderlinedTextL( const TDesC& aText );

        /**
        * Draw one line.
        */
        void DrawLineL();

        /**
        * Add one line break.
        */
        void AddCarriageReturnL();

        /**
        * Adds a line of text to the text area
        */
        void ShowMessageL(const TDesC& aMsg);

        /**
        * From CoeControl,SizeChanged.
        */
        void SizeChanged();
                
        /**
        * Removes all text
        */ 
        void ClearScreenL();
        
    private: // Functions from base classes

        /**
        * From CoeControl,CountComponentControls.
        */
        TInt CountComponentControls() const;

        /**
        * From CCoeControl,ComponentControl.
        */
        CCoeControl* ComponentControl(TInt aIndex) const;

        /**
        * From CoeControl, OfferKeyEventL
        */
        TKeyResponse OfferKeyEventL(const TKeyEvent& aKeyEvent,TEventCode aType);

        void Draw( const TRect& aRect ) const;
        
    private:
        TInt GetScrollbarWidth() const;
        
    private: //data

        // Editor
        CRichTextEditorRTE* iRte;
    };

#endif // BLUETOOTH_EXAMPLE_RTE_CONTAINER
