/*
 * Copyright  2009 Nokia Corporation.
 */

#ifndef BLUETOOTH_EX_RICHTEXTEDITOR_H
#define BLUETOOTH_EX_RICHTEXTEDITOR_H

// INCLUDES
#include <eikrted.h> // CCEikRichTextEditor
#include <txtfrmat.h> // TCharFormatMask
#include <gdi.h>

// CLASS DECLARATION

// Constant used with function AddCarriageReturnL when
// the carriage return is wished to be added to end of document
const TInt KCarriageReturnToEnd = -1;

/**
*  CRichTextEditorRTE Editor that prints text.
*/
class CRichTextEditorRTE : public CEikRichTextEditor
    {


    public:

        /**
        * Create a CRichTextEditorRTE object.
        * @return Instance of CRichTextEditorRTE.
        */
        static CRichTextEditorRTE* NewL();

        /**
        * Create a CRichTextEditorRTE object.
        * @return Instance of CRichTextEditorRTE.
        */
        static CRichTextEditorRTE* NewLC();


    public: // from CoeControl

        TKeyResponse OfferKeyEventL(const TKeyEvent& aKeyEvent, TEventCode aType);

    public: // members

        /**
        * Add one carriage return to the spesified position.
        */
        void AddCarriageReturnL (TInt pos);

        /**
        * Print text on the screen.
        * @param aText text to be displayed
        */
        void AddTextL (const TDesC& aText);

        /**
        * Set text undeline on.
        * @param aUnderlineOn ETrue if underline is used, EFalse otherwise.
        */
        void SetTextUnderlineOn(TBool aUnderlineOn);

        /**
        * Print text on the screen. No Carriage return at the end.
        * @param aText text to be displayed
        */
        void DrawTextWithoutCarriageL( const TDesC& aText );

        /**
        * Draw a line that separates log events
        */
        void DrawLineL();

        /**
        * Clears the screen from log text
        */
        void ClearScreenL();
        
    private: // Basic two-phase symbian OS constructors

        void ConstructL();

        /**
        * Default contructor.
        */
        CRichTextEditorRTE();

    private: //data

        // Formatting options for the RichText
        TCharFormatMask iCharacterFormatMask;
        TCharFormat iCharacterFormat;
    };

#endif  // BLUETOOTH_EX_RICHTEXTEDITOR_H
