/*
 * Copyright  2009 Nokia Corporation.
 */

// INCLUDE FILES
#include    "BluetoothPMPExampleApp.h"
#include    "BluetoothPMPExampleDocument.h"

#include <eikstart.h>

// ----------------------------------------------------------------------------
// CBluetoothPMPExampleApp::AppDllUid()
//
// returns application UID
// ----------------------------------------------------------------------------
TUid CBluetoothPMPExampleApp::AppDllUid() const
    {
    return KUidBluetoothPMPExample;
    }

   
// ----------------------------------------------------------------------------
// CBluetoothPMPExampleApp::CreateDocumentL()
//
// creates CBluetoothPMPExampleDocument object
// ----------------------------------------------------------------------------
CApaDocument* CBluetoothPMPExampleApp::CreateDocumentL()
    {
    return CBluetoothPMPExampleDocument::NewL( *this );
    }


// ----------------------------------------------------------------------------
// NewApplication() 
//
// constructs CBluetoothPMPExampkeApp
// ----------------------------------------------------------------------------
EXPORT_C CApaApplication* NewApplication()
    {
    return new CBluetoothPMPExampleApp;
    }

// ----------------------------------------------------------------------------
// E32Dll(TDllReason) 
//
// entry point function for EPOC Apps
// ----------------------------------------------------------------------------
GLDEF_C TInt E32Main()
    {
    return EikStart::RunApplication(NewApplication);
    }

// End of File  

