/*
 * Copyright  2009 Nokia Corporation.
 */

// INCLUDE FILES
#include <avkon.hrh>
#include <eikmenup.h>
#include <AknGlobalNote.h>  //avkon.lib, aknnotify.lib
#include <BtPmpEx.rsg>
#include <aknutils.h>

#include "BluetoothPMPExampleAppUi.h"
#include "bluetoothpmpexample.hrh"

#include "BluetoothPMPExampleEngine.h"
#include "BluetoothPMPExampleRTEContainer.h"


// ----------------------------------------------------------------------------
// CBluetoothExampleAppUi::ConstructL()
//
// standard EPOC 2nd phase constructor
// ----------------------------------------------------------------------------
void CBluetoothPMPExampleAppUi::ConstructL()
    {
    BaseConstructL(EAknEnableSkin);

    #ifdef __WINS__
        //in emulator do nothing
        _LIT(KEmulatorWarning,"This application should be tested on device or use S60bt driver on Emulator");
        CAknGlobalNote* note = CAknGlobalNote::NewLC();
        note->ShowNoteL(EAknGlobalConfirmationNote,  KEmulatorWarning);
        CleanupStack::PopAndDestroy(note);
    #endif

    //Create container first so engine can display messages right away
    TRect rect;
    AknLayoutUtils::LayoutMetricsRect(AknLayoutUtils::EMainPane,rect);
    iContainer = CBluetoothPMPExampleRTEContainer::NewL(rect);
    iContainer->SetMopParent( this );

    // Reset UI to init position
    ResetUiL();

    // Create engine
    iEngine = CBluetoothPMPExampleEngine::NewL( *this );
    iEngine->TurnBtOnL();

    // add view to control stack
    AddToStackL( iContainer );
    }

void CBluetoothPMPExampleAppUi::ResetUiL()
    {
    TBuf<KMaxTimeFormatSpec+KMaxTimeFormatSpec> time;
    TTime now;
    now.HomeTime(); // Current time
    now.FormatL(time,TTimeFormatSpec());
    iContainer->ClearScreenL();
    iContainer->DrawTextL(KInfo);
    iContainer->DrawTextL(time);
    iContainer->AddCarriageReturnL();
    }


// ----------------------------------------------------------------------------
// CBluetoothPMPExampleAppUi::~CBluetoothPMPExampleAppUi()
//
// destructor
// ----------------------------------------------------------------------------
CBluetoothPMPExampleAppUi::~CBluetoothPMPExampleAppUi()
    {
    RemoveFromStack( iContainer );

    delete iContainer;
    iContainer = NULL;

    delete iEngine;
    iEngine=NULL;
    }

// ----------------------------------------------------------------------------
// CBluetoothPMPExampleAppUi::DynInitMenuPaneL(TInt aResourceId,
//     CEikMenuPane* aMenuPane)
//
// this function is called by the EIKON framework just before it displays
// a menu pane. Its default implementation is empty, and by overriding it,
// the application can set the state of menu items dynamically according
// to the state of application data.
// ----------------------------------------------------------------------------
void CBluetoothPMPExampleAppUi::DynInitMenuPaneL(TInt aResourceId,
                                                 CEikMenuPane* aMenuPane)
    {
    if (aResourceId == R_BLUETOOTHPMPEXAMPLE_MENU)
        {
        TBool myActiveDiscovery( iEngine->IsDiscoveryActive()  );

        // Dimm all menu items
        aMenuPane->SetItemDimmed(EBTCmdSendMessage, ETrue);
        aMenuPane->SetItemDimmed(EBTCmdStartSlave, ETrue);
        aMenuPane->SetItemDimmed(EBTCmdDiscoverDevices, ETrue);
        aMenuPane->SetItemDimmed(EBTCmdStopDiscovery, ETrue);
        aMenuPane->SetItemDimmed(EBTCmdDiscoverServices, ETrue);
        aMenuPane->SetItemDimmed(EBTCmdConnectDevices, ETrue);
        aMenuPane->SetItemDimmed(EBTCmdDisconnect, ETrue);
        aMenuPane->SetItemDimmed(EBTCmdDisconnectDevices, ETrue);
        aMenuPane->SetItemDimmed(EBtCmdBluetoothSetLimitedDiscoverableStatusOn, ETrue);
        aMenuPane->SetItemDimmed(EBtCmdBluetoothSetLimitedDiscoverableStatusOff, ETrue);
        aMenuPane->SetItemDimmed(EBTCmdShowConnectedDevices, ETrue);
        
        // Slave Mode =========================================================
        if (iEngine->iIsSlave)
            {
            if ( iEngine->iListener->IsConnected() )
                {
                aMenuPane->SetItemDimmed(EBTCmdSendMessage, EFalse);
                }
            aMenuPane->SetItemDimmed(EBTCmdDisconnect, EFalse);
            }
        // Master Mode ========================================================
        else if (iEngine->iIsMaster)
            {
            aMenuPane->SetItemDimmed(EBTCmdStopDiscovery, !myActiveDiscovery );
            aMenuPane->SetItemDimmed(EBTCmdDiscoverDevices, myActiveDiscovery );
            if ( iEngine->iDeviceDiscoverer->HasDevices() && !iEngine->iDeviceDiscoverer->IsActive())
                {
                // we have found devices, show discover services item
                aMenuPane->SetItemDimmed(EBTCmdDiscoverServices, EFalse);
                }
            if ( iEngine->iServiceDiscoverer->HasServices() && !iEngine->iServiceDiscoverer->iRunning)
                {
                // we have found services, show connect item
                aMenuPane->SetItemDimmed(EBTCmdConnectDevices, EFalse);
                }
            if ( iEngine->HasConnections() )
                {
                // we are connected
                aMenuPane->SetItemDimmed(EBTCmdSendMessage, EFalse);
                aMenuPane->SetItemDimmed(EBTCmdShowConnectedDevices, EFalse);
                aMenuPane->SetItemDimmed(EBTCmdDisconnectDevices, EFalse);

                aMenuPane->SetItemDimmed(EBTCmdConnectDevices, ETrue);
                }
            }
        // Init state =========================================================
        else
            {
            aMenuPane->SetItemDimmed(EBTCmdStartSlave, EFalse);
            aMenuPane->SetItemDimmed(EBTCmdDiscoverDevices, EFalse);
            }
        
        // LIAC ===============================================================
        #ifdef ENABLE_LIAC
        // If device discovering is ongoing do not allow to change LIAC state
        if (myActiveDiscovery)
            {
            aMenuPane->SetItemDimmed(
                    EBtCmdBluetoothSetLimitedDiscoverableStatusOn, ETrue );
            aMenuPane->SetItemDimmed(
                    EBtCmdBluetoothSetLimitedDiscoverableStatusOff, ETrue );
            }
        else
            {
            TBool myLIAC( iEngine->LIAC() );
            aMenuPane->SetItemDimmed(
                    EBtCmdBluetoothSetLimitedDiscoverableStatusOn, myLIAC);
            aMenuPane->SetItemDimmed(
                    EBtCmdBluetoothSetLimitedDiscoverableStatusOff, !myLIAC);
            }
        #else
        // LIAC is not supported on S60 1st or 2nd editions
        aMenuPane->SetItemDimmed(
            EBtCmdBluetoothSetLimitedDiscoverableStatusOn, ETrue );
        aMenuPane->SetItemDimmed(
            EBtCmdBluetoothSetLimitedDiscoverableStatusOff, ETrue );
        #endif

        
        
        }
    }



// ----------------------------------------------------------------------------
// CBluetoothPMPExampleAppUi::HandleKeyEventL(
//     const TKeyEvent& aKeyEvent,TEventCode /*aType*/)
//
// takes care of key event handling
// ----------------------------------------------------------------------------
TKeyResponse CBluetoothPMPExampleAppUi::HandleKeyEventL(
    const TKeyEvent& /*aKeyEvent*/,TEventCode /*aType*/)
    {
    return EKeyWasNotConsumed;
    }


// ----------------------------------------------------------------------------
// CBluetoothPMPExampleAppUi::HandleCommandL(TInt aCommand)
//
// takes care of command handling
// ----------------------------------------------------------------------------
void CBluetoothPMPExampleAppUi::HandleCommandL(TInt aCommand)
    {
    switch ( aCommand )
        {
        case EEikCmdExit:
        case EAknSoftkeyExit:
        case EAknCmdExit:
        case EAknSoftkeyBack:
            {
            iEngine->StopDiscovery();
            Exit();
            break;
            }
        case EBTCmdStartSlave:
            {
            if ( !iEngine->iIsSlave )
                iEngine->StartSlaveL();
            break;
            }
        case EBTCmdDiscoverDevices:
            {
            if ( !iEngine->iIsSlave )
                iEngine->DiscoverDevicesL();
            break;
            }
        case EBTCmdDiscoverServices:
            {
            if ( !iEngine->iIsSlave )
                iEngine->DiscoverServicesL();
            break;
            }
        case EBTCmdConnectDevices:
            {
            if ( !iEngine->iIsSlave )
                iEngine->ConnectDevicesL();
            break;
            }
        case EBTCmdDisconnect:
            {
            if ( iEngine->iIsSlave )
                {
                iEngine->StopSlaveL();
                ResetUiL();
                }
            break;
            }
        case EBTCmdDisconnectDevices:
            {
            if ( !iEngine->iIsSlave )
                iEngine->DisconnectDevices();
            break;
            }
        case EBTCmdShowConnectedDevices:
            {
            if ( !iEngine->iIsSlave )
                iEngine->ShowConnectedDevicesL();
            break;
            }
        case EBTCmdSendMessage:
            {
            TRAPD(err,iEngine->SendMessageL() );
            if( err )
                iContainer->ShowMessageL( KMsgSendFailed );
            break;
            }
        case EBtCmdClearScreen:
            {
            iContainer->ClearScreenL();
            break;
            }
#ifdef ENABLE_LIAC
        case EBtCmdBluetoothSetLimitedDiscoverableStatusOn:
            {
            iEngine->SetLIAC( ETrue );
            break;
            }
        case EBtCmdBluetoothSetLimitedDiscoverableStatusOff:
            {
            iEngine->SetLIAC( EFalse );
            break;
            }
#endif
        case EBTCmdStopDiscovery:
            {
            iEngine->StopDiscovery();
            break;
            }

        default:
            break;
        }
    }

void CBluetoothPMPExampleAppUi::HandleResourceChangeL(TInt aType)
    {
    CAknAppUi::HandleResourceChangeL(aType);
    if ( aType == KEikDynamicLayoutVariantSwitch )
        {
        TRect rect;
        AknLayoutUtils::LayoutMetricsRect(AknLayoutUtils::EMainPane,rect);
        iContainer->SetRect(rect);
        }
    }


CBluetoothPMPExampleRTEContainer* CBluetoothPMPExampleAppUi::Container()
    {
    return iContainer;
    }

// End of File
