/*
 * Copyright  2009 Nokia Corporation.
 */

// INCLUDE FILES
#include "BluetoothPMPExampleRTEContainer.h"
#include "BluetoothPMPExampleRichtexteditorrte.h"

// ----------------------------------------------------------------------------
// CBluetoothPMPExampleRTEContainer::NewL(const TRect& aRect)
//
// Symbian OS 2 phase constructor.
// ----------------------------------------------------------------------------
CBluetoothPMPExampleRTEContainer* CBluetoothPMPExampleRTEContainer::NewL(const TRect& aRect)
    {
    CBluetoothPMPExampleRTEContainer* self = CBluetoothPMPExampleRTEContainer::NewLC(aRect);
    CleanupStack::Pop(self);
    return self;
    }

// ----------------------------------------------------------------------------
// CBluetoothPMPExampleRTEContainer::NewLC(const TRect& aRect)
//
// Symbian OS 2 phase constructor.
// ----------------------------------------------------------------------------
CBluetoothPMPExampleRTEContainer* CBluetoothPMPExampleRTEContainer::NewLC(const TRect& aRect)
    {
    CBluetoothPMPExampleRTEContainer* self = new (ELeave) CBluetoothPMPExampleRTEContainer;
    CleanupStack::PushL(self);
    self->ConstructL(aRect);
    return self;
    }

// ---------------------------------------------------------
// CBluetoothPMPExampleRTEContainer::ConstructL(const TRect& aRect)
// Symbian OS two phased constructor.
// ---------------------------------------------------------
//
void CBluetoothPMPExampleRTEContainer::ConstructL(const TRect& aRect)
    {
    CreateWindowL();

    iRte = CRichTextEditorRTE::NewL();
    iRte->SetContainerWindowL(*this);
    // Scroll bars
    iRte->CreateScrollBarFrameL()->SetScrollBarVisibilityL(
            CEikScrollBarFrame::EOff, CEikScrollBarFrame::EOn);
    iRte->UpdateScrollBarsL();
    
    ActivateL();

    // Set the windows size
    // NOTE: To call this after ActivateL() is solution to get
    // scrollbarframe width in SizeChanged() method.
    SetRect(aRect);
    }

CBluetoothPMPExampleRTEContainer::~CBluetoothPMPExampleRTEContainer()
    {
    delete iRte;
    }

void CBluetoothPMPExampleRTEContainer::DrawUnderlinedTextL( const TDesC& aText )
    {
    iRte->SetTextUnderlineOn(ETrue);
    DrawTextWithoutCarriageL(aText);
    iRte->SetTextUnderlineOn(EFalse);
    iRte->UpdateScrollBarsL();
    }

void CBluetoothPMPExampleRTEContainer::DrawLineL()
    {
    iRte->DrawLineL();
    iRte->UpdateScrollBarsL();
    }

TInt CBluetoothPMPExampleRTEContainer::GetScrollbarWidth() const
    {
    TInt scrollbarWidth = iRte->ScrollBarFrame()->
        ScrollBarBreadth(CEikScrollBar::EVertical);
    // If scrollbars are not drawn yet, the width remains zero. In this
    // case, an intentionally magical number is returned.
    if (scrollbarWidth == 0)
        {
        scrollbarWidth = 8;
        }
    
    return scrollbarWidth;
    }

void CBluetoothPMPExampleRTEContainer::Draw( const TRect& /*aRect*/ ) const
    {
    CWindowGc& gc = SystemGc();  
    gc.Clear();
    }

void CBluetoothPMPExampleRTEContainer::SizeChanged()
    {
    TRect rect = Rect();
    TInt scrollbarWidth = GetScrollbarWidth();
    iRte->SetExtent(TPoint(0, 0),
            TSize(rect.Width() - scrollbarWidth, rect.Height()));
    iRte->UpdateScrollBarsL();
    }

void CBluetoothPMPExampleRTEContainer::DrawTextL( const TDesC& aText )
    {
    iRte->AddTextL( aText );
    iRte->UpdateScrollBarsL();
    }

void CBluetoothPMPExampleRTEContainer::DrawTextWithoutCarriageL( const TDesC& aText )
    {
    iRte->DrawTextWithoutCarriageL(aText);
    iRte->UpdateScrollBarsL();
    }

void CBluetoothPMPExampleRTEContainer::AddCarriageReturnL()
    {
    iRte->AddCarriageReturnL(KCarriageReturnToEnd);
    iRte->UpdateScrollBarsL();
    }

TInt CBluetoothPMPExampleRTEContainer::CountComponentControls() const
    {
    return 1; // return number of controls inside this container
    }

CCoeControl* CBluetoothPMPExampleRTEContainer::ComponentControl(TInt aIndex) const
    {
    switch ( aIndex )
        {
        case 0:
            return iRte;
        default:
            return NULL;
        }
    }

TKeyResponse CBluetoothPMPExampleRTEContainer::OfferKeyEventL(
                    const TKeyEvent& aKeyEvent,TEventCode aType)
    {
    if (iRte)
        return iRte->OfferKeyEventL(aKeyEvent, aType);
    else
        return CCoeControl::OfferKeyEventL(aKeyEvent, aType);
    }

void CBluetoothPMPExampleRTEContainer::ShowMessageL(const TDesC& aMsg)
    {
    DrawTextL(aMsg);
    }

void CBluetoothPMPExampleRTEContainer::ClearScreenL()
    {
    iRte->ClearScreenL();
    iRte->UpdateScrollBarsL();
    }

