/*
 * Copyright  2009 Nokia Corporation.
 */

// INCLUDES
#include "BluetoothPMPExamplerichtexteditorrte.h"
#include <barsread.h> // TResourceReader
#include <BtPmpEx.rsg> // resources
#include <eikrted.h> // CEikRichTextEditor
#include <txtrich.h> // CRichText

_LIT(KTextLines, "---------------------------");
#define NEW_TEXT_TO_TOP //If defined the new text will be written to
                        //the top of the container
// ----------------------------------------------------------------------------
// CRichTextEditorRTE::CRichTextEditorRTE(void)
//
// Standard symbian OS 2nd phase constructor
// ----------------------------------------------------------------------------
void CRichTextEditorRTE::ConstructL()
    {
    TResourceReader reader;

    // Construct RichTextEditor from resource
    iCoeEnv->CreateResourceReaderLC(reader, R_RICHTEXTEDITOR_RICH_TEXT_EDITOR);

    ConstructFromResourceL(reader);

    CleanupStack::PopAndDestroy(); // reader

    // Sets that the control has keyboard focus
    SetFocus(ETrue);
    }


// ----------------------------------------------------------------------------
// CRichTextEditorRTE::CRichTextEditorRTE(void)
//
// Constructor
// ----------------------------------------------------------------------------
CRichTextEditorRTE::CRichTextEditorRTE(void)
    {
    }

// ----------------------------------------------------------------------------
// CRichTextEditorRTE::AddCarriageReturnL()
//
// Insert one line break at the end of the text.
// ----------------------------------------------------------------------------
void CRichTextEditorRTE::AddCarriageReturnL(TInt pos)
    {
    CRichText* richText = RichText();
    TInt carriagePosition = pos;
    if(pos == KCarriageReturnToEnd)
        {
        carriagePosition = richText->DocumentLength();
        }

    richText->InsertL(carriagePosition, CEditableText::ELineBreak);
    }


// ----------------------------------------------------------------------------
// CRichTextEditorRTE::AddTextL(const TDesC& aText)
//
// Draws text using black color.
// ----------------------------------------------------------------------------
void CRichTextEditorRTE::AddTextL(const TDesC& aText)
    {
    CRichText* text = RichText();
    TInt textSize = text->DocumentLength();
    TInt position = textSize;
    #ifdef NEW_TEXT_TO_TOP
        position = 0;
    #endif

    // Interested in color
    iCharacterFormatMask.SetAttrib(EAttColor);
    // Set it to Black
    iCharacterFormat.iFontPresentation.iTextColor = KRgbBlack;
    
    text->InsertL (position, aText);

    // Apply formatting
    text->ApplyCharFormatL(iCharacterFormat, iCharacterFormatMask,
                           position,aText.Length());

    AddCarriageReturnL(position);

    HandleTextChangedL();


    #ifdef NEW_TEXT_TO_TOP
        //Keep displaying the top of the screen
        MoveCursorL (TCursorPosition::EFPageUp, EFalse);
    #else
        //Keep displaying the bottom of the screen
        MoveCursorL (TCursorPosition::EFPageDown, EFalse);
    #endif    
    }

// ----------------------------------------------------------------------------
// CRichTextEditorRTE::DrawTextWithoutCarriageL( const TDesC& aText )
//
// Draw text without adding one line break at the end of the text.
// ----------------------------------------------------------------------------
void CRichTextEditorRTE::DrawTextWithoutCarriageL( const TDesC& aText )
    {
    CRichText* text = RichText();
    TInt textSize = text->DocumentLength();

    // Interested in color
    iCharacterFormatMask.SetAttrib(EAttColor);
    // Set it to Black
    iCharacterFormat.iFontPresentation.iTextColor = KRgbBlack;
    text->InsertL (textSize, aText);
    // Apply formatting
    text->ApplyCharFormatL(iCharacterFormat, iCharacterFormatMask,
                           textSize,aText.Length());
    HandleTextChangedL();
    }


// ----------------------------------------------------------------------------
// CRichTextEditorRTE::DrawTextWithoutCarriageL( const TDesC& aText )
//
//  Sets underline on or off.  This will be applied to text added in AddTextL()
// ----------------------------------------------------------------------------
void CRichTextEditorRTE::SetTextUnderlineOn(TBool aUnderlineOn)
    {
    iCharacterFormatMask.SetAttrib(EAttFontUnderline);
    if (aUnderlineOn)
        {
        iCharacterFormat.iFontPresentation.iUnderline = EUnderlineOn;
        }
    else
        {
        iCharacterFormat.iFontPresentation.iUnderline = EUnderlineOff;
        }
    }

// ----------------------------------------------------------------------------
// CRichTextEditorRTE::DrawLineL()
//
// Draw one line.
// ----------------------------------------------------------------------------
void CRichTextEditorRTE::DrawLineL()
    {
    AddTextL( KTextLines );
    HandleTextChangedL();
    }

// ----------------------------------------------------------------------------
// CRichTextEditorRTE::NewL()
//
// Symbian OS 2nd phase constructor.
// ----------------------------------------------------------------------------
CRichTextEditorRTE* CRichTextEditorRTE::NewL()
    {
    CRichTextEditorRTE* self = CRichTextEditorRTE::NewLC();
    CleanupStack::Pop(self);
    return self;
    }

// ----------------------------------------------------------------------------
// CRichTextEditorRTE::NewLC()
//
// Symbian OS 2nd phase constructor.
// ----------------------------------------------------------------------------
CRichTextEditorRTE* CRichTextEditorRTE::NewLC()
    {
    CRichTextEditorRTE* self = new (ELeave) CRichTextEditorRTE;
    CleanupStack::PushL(self);
    self->ConstructL();
    return self;
    }

// ----------------------------------------------------------------------------
// TKeyResponse CRichTextEditorRTE::OfferKeyEventL(const TKeyEvent& aKeyEvent,
//      TEventCode aType)
//
// Called by the framework whenever a key event occurs. Handles scrolling
// events.
// ----------------------------------------------------------------------------
TKeyResponse CRichTextEditorRTE::OfferKeyEventL(const TKeyEvent& aKeyEvent,
                                                TEventCode aType)
    {

    if (aType == EEventKey)
        {
        if (aKeyEvent.iCode == EKeyDownArrow)
            {
            MoveCursorL (TCursorPosition::EFPageDown, EFalse);

            return EKeyWasConsumed;
            }
        else if (aKeyEvent.iCode == EKeyUpArrow)
            {
            MoveCursorL (TCursorPosition::EFPageUp, EFalse);

            return EKeyWasConsumed;
            }
        else
            {
            return CEikRichTextEditor::OfferKeyEventL(aKeyEvent, aType);
            }
        }

    return EKeyWasNotConsumed;
    }

void CRichTextEditorRTE::ClearScreenL()
    {
    CRichText* text = RichText();
    text->DeleteL(0, text->DocumentLength() );
    HandleTextChangedL();
    }
