// helloworldexeexample.c
//
// Copyright (c) 2007-2009 Nokia Corporation and/or its subsidiary(-ies).
// All rights reserved.
// This component and the accompanying materials are made available
// under the terms of "Eclipse Public License v1.0"
// which accompanies this distribution, and is available
// at the URL "http://www.eclipse.org/legal/epl-v10.html".
//
// Initial Contributors:
// Nokia Corporation - initial contribution.
//
// Contributors:
//
// Description:
//


/* This example is a simple PIPS STDEXE application. It loads the DLL and calls its exported function. 
The application implements the dynamic lookup by name mechanism of the exported function using the libdl APIs.
*/

// Include files.
#include <stdio.h>
#include <dlfcn.h>
#include <stdlib.h>

/**
Waits for key press event.  
*/
void PressAKey()
	{
	fflush(stdout);
	getchar();
	}
/**
Get and display the most recent error that occurred due to any of the dynamic lookup routines.
@return EXIT_FAILURE Returns the failure code.
*/
int DisplayErrorMessage()
	{
	// Obtain the last error occurred using the libdl API, dlerror().
	const char *q = dlerror();
	
	// Prints the error message.
	printf("%s",q);
	PressAKey();
		
	// returns the failure code.
	return EXIT_FAILURE;
	}

int main()
{
	int result;
	
	// Handle to load the dynamic library.
	void* handleToDll;
	
	typedef void (*PrintHelloWorldFunction)(void);
	PrintHelloWorldFunction PrintHelloWorld;
	
	// Contains name of the DLL file.
	char dllFileName[] = "helloworlddllexample.dll";

	/**
	Loads the DLL using the libdl API dlopen(), to gain access to the symbols in it.
	It takes two parameters: the name of the DLL file and the mode in which it has to be loaded.
	This returns a NULL, if it fails for any reason.Otherwise, it returns a descriptor.
	*/
	handleToDll = dlopen(dllFileName, RTLD_LAZY);
	
	// Check the descriptor value.If it is null, the error message is printed.
	if (!handleToDll)
		{
		DisplayErrorMessage();
		}
	
	// Print the message to start the example application.
	printf(" Press enter key to step through the example application\n");
	PressAKey();

	/**
	Locates the symbol using the libdl API, dlsym(). 
	It takes the handle returned by the dlopen() function and the symbol name to find.
	This returns the address binding of the symbol, PrintHelloWorld if successful. Otherwise, it returns NULL.
	*/
	PrintHelloWorld = (PrintHelloWorldFunction)dlsym(handleToDll, "PrintHelloWorld");   
	
	// Check the symbol address value. If this is null, the error message is printed.
	if(!PrintHelloWorld)
		{
		DisplayErrorMessage();
		}

	// Call the loaded DLL's exported function.
	PrintHelloWorld();

	/**
	Remove the dlopen-ed handle from the cache, maintained by dlopen(), using libdl API, dlclose().
	It takes the handle returned by the dlopen() function to decrement the reference count associated with the DLL.
	When the reference count reaches zero, the DLL is unloaded from the process address space.
	This API returns 0 if successful, otherwise it returns -1.
	*/
	result= dlclose(handleToDll);
	
	// Check the return value. If this is -1, the error message is printed.
	if(result == -1)
		{
		DisplayErrorMessage();
		}
	
	// Print the message to exit from the example application.
	printf(" Press enter key to exit from the example application");
	PressAKey();
	
	// returns the success code.
	return EXIT_SUCCESS;
}



