// Copyright (c) 2009 Nokia Corporation and/or its subsidiary(-ies).
// All rights reserved.
// This component and the accompanying materials are made available
// under the terms of "Eclipse Public License v1.0"
// which accompanies this distribution, and is available
// at the URL "http://www.eclipse.org/legal/epl-v10.html".
//
// Initial Contributors:
// Nokia Corporation - initial contribution.
//
// Contributors:
//
// Description:
//

#ifndef RCONNECTION_H
#define RCONNECTION_H

#include <e32cons.h>
#include <in_sock.h>

#include <es_enum.h>
#include <commdbconnpref.h>

class CRConnection : public CBase
	{
public:
	
	//Constructor.
	CRConnection(CConsoleBase* aConsole);
	
	//Destructor.
	~CRConnection();
	
	//Opens a session to the socket server and opens a connection that monitors for interface notification.
	void StartESOCK();
	
	//Demonstrates various RConnection API methods using default Commdb settings.
	void DemoApiWithoutDbOverrideL();
	
	//Demonstrates various RConnection API methods using non-default Commdb settings.
	void DemoApiWithDbOverrideL();
	
	//Starts a connection then attaches another connection to the same interface.
	void AttachToExistingInterfaceL();
	
	//Opens and starts a connection using non-default Commdb settings.
	TInt ConnectWithDbOverrideL();
	
	//Opens and starts a connection using default Commdb settings.
	TInt ConnectWithoutDbOverrideL();
	
	//Requests notification of the connection's progress.
	void GetProgressNotification();
	
	//Prints progress information to the console.
	void DisplayProgressinfo(const TNifProgress& aProgress);
	
	//Displays text describing the next phase of the example.
	void DisplaySectionToDemo(const TDesC& aText);
	
	//Prepares the socket for carrying out data transfer.
	TInt PrepareSocket();
	
	//Sends UDP packets over a socket.
	TInt SendUdpData(TUint aPayloadSize);
	
	//Receives UDP packets over a socket.
	TInt RecvUdpData(TUint aPayloadSize);
	
	//Calls SendUdpData() and RecvUdpData().
	void DataSendAndReceive(TUint aPayloadSize);
	
	//Gets the amount of data that has been transferred by the entire connection.
	void DataTransferredRequest();
	
	//Requests notification when a certain amount of data has been sent or received.
	void DataTransferNotificationRequest();
	
	
private:
	RConnection 	iConnection;
	RSocket 		iSocket; 
	RSocketServ		iSocketServ;
	CConsoleBase* 	iConsole;
	TInetAddr 		iDestAddr;
	TInt 			iCurrentProgress;
	RConnection 	iMonitor;
 	
	};
	
#endif //RCONNECTION_H
