// Copyright (c) 2000-2009 Nokia Corporation and/or its subsidiary(-ies).
// All rights reserved.
// This component and the accompanying materials are made available
// under the terms of "Eclipse Public License v1.0"
// which accompanies this distribution, and is available
// at the URL "http://www.eclipse.org/legal/epl-v10.html".
//
// Initial Contributors:
// Nokia Corporation - initial contribution.
//
// Contributors:
//
// Description:
// Show how RTimer, the basic timer class, works
//

#include "CommonFramework.h"


void showTimeL(TTime aTime)
	{
		// Format time, using system default locale settings
		// and then print the time using system default time
		// separator character (':') in 24 hour clock format.

	TBuf<40> timeString; // Holds the formatted date and time
	_LIT(KFormat1,"%:0%H%:1%T%:2%S%:3");
	aTime.FormatL(timeString,KFormat1);
	_LIT(KFormat2,"(24 hr clock) = %S\n");
	console->Printf(KFormat2, &timeString);
	}


void WaitForKey()
	{
	_LIT(KTxtPressAnyKey,"Press any key to continue\n\n");
	console->Printf(KTxtPressAnyKey);
	console->Getch();
	}


LOCAL_C void doExampleL()
    {
	RTimer timer;				 // The asynchronous timer and ...
	TRequestStatus timerStatus;  // ... its associated request status
	timer.CreateLocal();         // Always created for this thread.

		// do some After() requests
	_LIT(KTxt1,"Doing 10 after requests\n");
	console->Printf(KTxt1);
	for (TInt i=0; i<10; i++)
		{
			// issue and wait for single request
		timer.After(timerStatus,1000000);  // wait 1 second
		User::WaitForRequest(timerStatus); // wait for request to complete
			// display the tick count
		_LIT(KFormat3,"Request count %d\n");
		console->Printf(KFormat3, i);
		}

    WaitForKey(); // wait until a key is pressed

		// do an At() request
	TTime time; // time in microseconds since 0AD nominal Gregorian
	_LIT(KTxt2,"The time now is, ");
	console->Printf(KTxt2);
		
		// set and print current time
	time.HomeTime(); 
	showTimeL(time); 
		
		// add 10 seconds to the time
	TTimeIntervalSeconds timeIntervalSeconds(10);
	time += timeIntervalSeconds;
	_LIT(KTxt3,"Doing a request ten seconds from now at, ");
	console->Printf(KTxt3);
	showTimeL(time); // print the time the request should complete
		
		// issue and wait for single request.
		// set timer to go off in 10 seconds
	timer.At(timerStatus,time); 
	
	   // wait for request to complete
	User::WaitForRequest(timerStatus); 
		
		// say it's over, and set and print the time again
	_LIT(KTxt4,"Your 10 seconds are up\nThe time now is, ");
	console->Printf(KTxt4);
	
	   // set time to now
	time.HomeTime(); 
	
	   // print the time
	showTimeL(time); 
		
		// close timer
	timer.Close();
	}

