// Copyright (c) 2008-2009 Nokia Corporation and/or its subsidiary(-ies).
// All rights reserved.
// This component and the accompanying materials are made available
// under the terms of "Eclipse Public License v1.0"
// which accompanies this distribution, and is available
// at the URL "http://www.eclipse.org/legal/epl-v10.html".
//
// Initial Contributors:
// Nokia Corporation - initial contribution.
//
// Contributors:
//
// Description:
// Contains the definition of the TDigit class.
//



/**
 @file
*/
#ifndef __DIGIT_H__
#define __DIGIT_H__

#include "sgllist.h"

/**
This class represents a decimal digit of an integer number.
It is an element of a singly linked list.
A singly linked list of elements of this class represents an integer number.
@see CLongNumber::iNumber.
*/
class TDigit
	{
public:
	TDigit();
	void Set(TInt iDigit);
	TInt Get();
private:
	/**
	Stores a single digit decimal integer.
	*/
	TInt iDigit;
public:
	/**
	The link object for the singly linked list.
	*/
	TSglQueLink iSLink;
	};

#endif

