// Copyright (c) 2008-2009 Nokia Corporation and/or its subsidiary(-ies).
// All rights reserved.
// This component and the accompanying materials are made available
// under the terms of "Eclipse Public License v1.0"
// which accompanies this distribution, and is available
// at the URL "http://www.eclipse.org/legal/epl-v10.html".
//
// Initial Contributors:
// Nokia Corporation - initial contribution.
//
// Contributors:
//
// Description:
// Contains the definition of the CLongNumber class.
//



/**
 @file
*/
#ifndef __LONGNUMBER_H__
#define __LONGNUMBER_H__

#include "digit.h"

/**
This class has an object of the TSglQue class, which represents the digits of an integer number list.
It is derived from the CActive class to handle asynchronous user inputs.
It has methods to:
- edit the linked list
- traverse the linked list using an iterator
*/
class CLongNumber : public CActive
	{
private:
	/**
	The enumeration that describes the operations performed by this class.
	*/
	enum TOption	{
					ETOptionNone,
					/**
					Call the TSglQue::AddFirst() function.
					*/
					EAddFirst, 
					/**
					Call the TSglQue::AddLast() function.
					*/
					EAddLast,
					/**
					Call the TSglQue::Remove() function.
					*/
					ERemove
					};
public:
	static CLongNumber* NewL(CConsoleBase* aConsole);
	void RunL();
	void DoCancel();
	void AddToScheduler();
	void ReadNumber();
	~CLongNumber();
	void PrintNumber();
	void InitializeIter();
	TBool GetNumber(TInt& aValue);
	TBool Slide();
private:
	CLongNumber(CConsoleBase* aConsole);
	void ReadFunc();
private:
	/**
	The singly linked list, which represents a number.
	*/
	TSglQue<TDigit> iNumber;
	/**
	The user console.
	*/
	CConsoleBase* iConsole;
	/** 
	The option selected by the user. Add an element to the start or end of the list.
	*/
	TOption iOption;
	/**
	The iterator of the singly linked list.
	*/
	TSglQueIter<TDigit> iIterator;
	};

#endif

