// Copyright (c) 2007-2009 Nokia Corporation and/or its subsidiary(-ies).
// All rights reserved.
// This component and the accompanying materials are made available
// under the terms of "Eclipse Public License v1.0"
// which accompanies this distribution, and is available
// at the URL "http://www.eclipse.org/legal/epl-v10.html".
//
// Initial Contributors:
// Nokia Corporation - initial contribution.
//
// Contributors:
//
// Description:
// Contains the CTransparentApplication, CTransparentDocument, CTransparentAppUi, CWait,
// CEventHandler and CTransparentDocument classes.
//



/**
 @file
*/
#ifndef __TRANSPARENT_H__
#define __TRANSPARENT_H__

#include <coeccntx.h>

#include <eikenv.h>
#include <eikappui.h>
#include <eikapp.h>
#include <eikdoc.h>
#include <eikmenup.h>
#include <eikstart.h>
#include <f32file.h>
#include <w32std.h>
#include <e32std.h>
#include <eikon.hrh>

#include <transparent.rsg>
#include "transparent.hrh"

_LIT(KEventButton1Pressed, "Event received for mouse button 1 being pressed");
_LIT(KEventButton2Pressed, "Event received for press of middle button of a 3 button mouse");
_LIT(KEventButton3Pressed, "Event received for last mouse button press");

const TInt KDelay=1000000;
class CEventHandler;
class CTransparentAppUi;

/**
CTransparentApplication provides methods that fetch
application specific UID and the document object.
*/
class CTransparentApplication : public CEikApplication
	{
private:
	CApaDocument* CreateDocumentL();
	TUid AppDllUid() const;
	};

/**
View class
*/
class CTransparentUtil : public CCoeControl
	{
public:
	static CTransparentUtil* NewL();
	static TBool Flag();
	CTransparentUtil();
	~CTransparentUtil();
	void ConstructL();

	void ClearWindow(RWsSession& aSession, RWindow& aWindow, CWindowGc* aGc, TRgb aColor);
	void DrawWindow(RWindow& aWindow, TRgb aColor1, TRgb aColor2, TRect aRect, const TDesC& aText);
	void DrawWindowRegion(RWindow& aWindow, TRgb aColor1, TRgb aColor2,TRect aChopRect, TRect aRect, const TDesC& aText, const TPoint& aPoint);
	
	void TransparencyVarianceL();
	void TransparentRegionL();

	TBool DoChangeTransparencyL();
	TBool DoSetTransparentRegion();

private:
	CPeriodic* iPeriodicObject;
	CEventHandler* iEventHandler;
	RWindowGroup iGroup;
	RWindow iBackgndWindow;
	RWindow iForegndWindowTrans;

	RWindow iFgndWinTransRegion;
	RWsSession iWs;
	CWsScreenDevice* iScr;
	CWindowGc* iGc;

	TSize iSize;
	TInt iAlphaValue;
	TInt iXOffset;
	TInt iYOffset;
	CFbsBitmapDevice* iBitmapDevice;
	CFbsBitGc* iBitmapGc;
	TInt iPos;
	TInt iColor;
	TBool iBoolVisible; 
public:
	TRegionFix<2> iRegion;
	};

/**
CTransparentAppUi handles application-wide aspects of the application's UI.
*/
class CTransparentAppUi : public CEikAppUi
	{
public:
	void ConstructL();
	~CTransparentAppUi();

private:
	void HandleCommandL(TInt aCommand);

private:
	CTransparentUtil* iUtil;
	};

/**
CTransparentDocument partially constructs the application UI object.
*/
class CTransparentDocument : public CEikDocument
	{
public:
	static CTransparentDocument* NewL(CEikApplication& aApp);
	CTransparentDocument(CEikApplication& aApp);
	void ConstructL();
private:
	CEikAppUi* CreateAppUiL();
	};

/**
Event handler class to receive pointer events and handle them
*/
class CEventHandler: public CActive
        {
    public:
        static CEventHandler* NewL(RWsSession& aWs);
        virtual ~CEventHandler();
        void HandlePointerEvent(TPointerEvent& aPointerEvent);
        void InfoMessage(const TDesC& aMsg);
        void IssueRequest();
    private:
        CEventHandler(RWsSession& aWs);
        void ConstructL();
        void RunL();
        void DoCancel();

    private:
        TWsEvent iWsEvent;
        RWsSession& iWs;
        };
#endif // __TRANSPARENT_H__

