// Copyright (c) 2007-2009 Nokia Corporation and/or its subsidiary(-ies).
// All rights reserved.
// This component and the accompanying materials are made available
// under the terms of "Eclipse Public License v1.0"
// which accompanies this distribution, and is available
// at the URL "http://www.eclipse.org/legal/epl-v10.html".
//
// Initial Contributors:
// Nokia Corporation - initial contribution.
//
// Contributors:
//
// Description:
//

#include "transparent.h"

/**
Second phase constructor of the application UI class.
It creates and owns a single view.
*/
void CTransparentAppUi::ConstructL()
	{
	// Complete the UI framework's construction of the App UI.
	BaseConstructL();
	// Create the appview.
	iUtil = CTransparentUtil::NewL();
	}

/**
The application UI class owns one view, and is responsible
for destroying it
*/
CTransparentAppUi::~CTransparentAppUi()
	{
	delete iUtil;
	}

/**
Called by the UI framework when a command has been issued.
*/
void CTransparentAppUi::HandleCommandL( TInt aCommand )
	{
	switch (aCommand)
		{
		case ETransparentToDo0:
			// Create a transparent foreground window over a background window,
			// both windows having some content drawn to them.
			// Vary the transparency of the foreground window in steps
			iUtil->TransparencyVarianceL();
			break;

		case ETransparentToDo1:
			// Create an opaque window with a transparent region having appropriate
			// content drawn to it to illustrate the presence of the region.
			iUtil->TransparentRegionL();
			break;

		case EEikCmdExit:
			Exit();
			break;
		}
	}

