// Copyright (c) 2008-2009 Nokia Corporation and/or its subsidiary(-ies).
// All rights reserved.
// This component and the accompanying materials are made available
// under the terms of "Eclipse Public License v1.0"
// which accompanies this distribution, and is available
// at the URL "http://www.eclipse.org/legal/epl-v10.html".
//
// Initial Contributors:
// Nokia Corporation - initial contribution.
//
// Contributors:
//
// Description:
// Contains definitions of the TTimerEntry and the CTimerEntry classes.
// It also defines the KMaxEntry variable.
//



/**
 @file
*/
#ifndef __TIMERENTRY_H__
#define __TIMERENTRY_H__

#include "deltaque.h"

const TUint KWaitTime = 2;
const TInt KMaxTimeToWait = 5;
const TUint KInterval = 1000000;

/**
The class that has an object of the TDeltaQueLink class.
It acts as the node of the delta queue.
*/
class TTimerEntry
	{
public:
	/**
	The link object of the delta queue.
	*/
	TDeltaQueLink iLink;
	};

/**
The maximum number of elements in the list.
*/
const TInt KMaxEntry = 5;

/**
This class has a delta queue of objects of the TTimerEntry class.

It triggers timer events at random intervals. At each such event,
either the tick count is added to the queue or an element is removed from the
queue based on the number of elements present in the queue.

The tick count is taken as the delta value of the queue and this value is
adjusted each time an object of the TTimerEntry class is added to the queue.

It also has methods to:
- add elements to the delta queue
- remove elements from the delta queue.
*/
class CTimerEntry : public CTimer
	{
private:
	/**
	This enumeration represents the two operations of the class.
	*/
	enum TOp{
			/**
			Increase the iCount variable.
			Denotes that nodes should be added to the list.
			*/
			EInsert,
			/**
			Decrease the iCount variable.
			Denotes that nodes should be removed from the list.
			*/
			ERemove
			};
public:
	static CTimerEntry* NewL(CConsoleBase* aConsole);
	~CTimerEntry();
	TBool AddToQueueL(TInt aInterval);
	void ArbitratorL();
	TBool RemoveFromQueue();
	void RunL();
	void DoCancel();
	void IssueRequest();
	void PrintQue();
private:
	CTimerEntry(CConsoleBase* aConsole);
	void ConstructL();
private:
	/**
	The delta queue.
	*/
	TDeltaQue<TTimerEntry> iQueue;
	/**
	The iterator of the linked list.
	*/
	TDblQueIter<TTimerEntry> iIterator;
	/**
	The count of objects in the iTimerEntryArray array.
	*/
	TInt iCount;
	/**
	Indicates the operation to be performed on the list.
	*/
	TOp iOp;
	/**
	The user console.
	*/
	CConsoleBase* iConsole;
	/**
	Denotes whether the timer should wait for more than 1 second.
	Elements are added to the queue after waiting for a random interval of time.
	Elements are removed from the queue every second.
	*/
	TBool iWaitFlag;
	};

#endif

