// Copyright (c) 2008-2009 Nokia Corporation and/or its subsidiary(-ies).
// All rights reserved.
// This component and the accompanying materials are made available
// under the terms of "Eclipse Public License v1.0"
// which accompanies this distribution, and is available
// at the URL "http://www.eclipse.org/legal/epl-v10.html".
//
// Initial Contributors:
// Nokia Corporation - initial contribution.
//
// Contributors:
//
// Description:
// Contains the E32Main() function, which executes the example.
// The example demonstrates the use of the TDeltaQue class, which represents
// a delta queue.
// An object of the CPeriodic class generates periodic timer events.
// Either the tick count is added to the delta queue or
// elements are removed from the list, depending on the state of the queue.
// The user can stop the generation of timer events by pressing a key.
//



/**
 @file
*/

#include "userinterface.h"

LOCAL_D CConsoleBase* console;

LOCAL_C void DoStartL();
LOCAL_C void CallExampleL();

LOCAL_C void DoStartL()
	{
	// Create and install the active scheduler.
	CActiveScheduler* scheduler = new (ELeave) CActiveScheduler();
	CleanupStack::PushL(scheduler);
	CActiveScheduler::Install(scheduler);

	_LIT(KTextExample, "Delta Queue Example\nCreating and starting timer object\n");
	console->Printf(KTextExample);
	
	// Create an object of the CTimerEntry class.
	CTimerEntry* entry = CTimerEntry::NewL(console);
	CleanupStack::PushL(entry);

	// Create an object of the CUserInterface class.
	CUserInterface* interface = CUserInterface::NewL(console,entry);
	CleanupStack::PushL(interface);

	// Wait for a key press from the user.
	// Generate an asynchronous read request.
	interface->ReadFunc();

	// Start the active scheduler.
	CActiveScheduler::Start();

	// Destroy the objects in the cleanup stack.
	CleanupStack::PopAndDestroy(3,scheduler); // interface, entry, scheduler.
	}

GLDEF_C TInt E32Main() // main function called by E32
    {
	__UHEAP_MARK;
	CTrapCleanup* cleanup=CTrapCleanup::New(); // get clean-up stack
	TRAPD(error, CallExampleL()); // more initialization, then do example
	delete cleanup; // destroy clean-up stack
	__ASSERT_ALWAYS(!error, User::Panic(KTxtEPOC32EX, error));
	__UHEAP_MARKEND;
	return 0; // and return
    }

LOCAL_C void CallExampleL() // initialize and call example code under cleanup stack
    {
	console=Console::NewL(KTxtExampleCode, TSize(KConsFullScreen, KConsFullScreen));
	CleanupStack::PushL(console);
	TRAPD(error, DoStartL()); // perform example function
	if (error)
		console->Printf(KFormatFailed, error);
	else
		console->Printf(KTxtOK);
	console->Printf(KTextPressAnyKey);
	console->Getch(); // get and ignore character
	CleanupStack::PopAndDestroy(); // close console
    }
