// Copyright (c) 2008-2009 Nokia Corporation and/or its subsidiary(-ies).
// All rights reserved.
// This component and the accompanying materials are made available
// under the terms of "Eclipse Public License v1.0"
// which accompanies this distribution, and is available
// at the URL "http://www.eclipse.org/legal/epl-v10.html".
//
// Initial Contributors:
// Nokia Corporation - initial contribution.
//
// Contributors:
//
// Description:
// Contains definition of functions defined in the CUserInterface class.
//



/**
 @file
*/

#include "userinterface.h"
/**
The static function to create an object of the CUserInterface class.
@param aConsole The console object.
@param aTimerEntry A pointer to an object of the CTimerEntry class.
@return A CUserInterface object.
*/
CUserInterface* CUserInterface::NewL(CConsoleBase* aConsole,CTimerEntry* aTimerEntry)
	{
	CUserInterface* self = new (ELeave)CUserInterface;
	self->Initialize(aConsole,aTimerEntry);
	return self;
	}

/**
Initialize the data members of the CUserInterface class.
@param aConsole The console object.
@param aTimerEntry A pointer to an object of the CTimerEntry class.
*/
void CUserInterface::Initialize(CConsoleBase* aConsole,CTimerEntry* aTimerEntry)
	{
	iConsole = aConsole;
	iTimerEntry = aTimerEntry;
	CActiveScheduler::Add(this);
	iTimerEntry->IssueRequest();
	}

/**
Constructor.
*/
CUserInterface::CUserInterface():CActive(CActive::EPriorityUserInput)
	{
	}

/**
Handles the key press events from the console.
It stops the active scheduler if any key is pressed.
*/
void CUserInterface::RunL()
	{
	// Get the key code.
	TUint8 option = iConsole->KeyCode();
	// Print the selected option.
	_LIT(KTextFormat,"%c\n");
	iConsole->Printf(KTextFormat,option);
	CActiveScheduler::Stop();
	}

/**
Issues an outstanding request to get a keystroke from the console.
*/
void CUserInterface::ReadFunc()
	{
	// Print the menu.
	_LIT(KTxtOption,"***\nPress any key to stop the scheduler\n***\n");
	iConsole->Printf(KTxtOption);
	// Wait for a key press event.
	iConsole->Read(iStatus);
	SetActive();
	}

/**
Cancel any outstanding request.
*/
void CUserInterface::DoCancel()
	{
	if(IsActive())
		{
		// Cancel any outstanding read requests.
		iConsole->ReadCancel();
		}
	}

/**
Destructor.
*/
CUserInterface::~CUserInterface()
	{
	Cancel();
	}
