/*
* ============================================================================
*  Name     : CRichTextEditorRTE from CRichTextEditorRTE.h
*  Part of  : Thread
*  Created  : 04.02.2005 by Forum Nokia
*  Description:
*      RichtTextEditor that prints text on the screen and handles scrolling.
*  Version  : 1.0
*  Copyright: Nokia Corporation
* ============================================================================
*/

#ifndef CRICHTEXTEDITOR_H
#define CRICHTEXTEDITOR_H

// INCLUDES
#include <eikrted.h> // CCEikRichTextEditor
#include <txtfrmat.h> // TCharFormatMask
#include <gdi.h>

// CLASS DECLARATION

/**
*  CRichTextEditorRTE Editor that prints text.
*/
class CRichTextEditorRTE : public CEikRichTextEditor
	{
public: 

/*!
* NewL()
*   
* discussion Create a CRichTextEditorRTE object, which will draw itself to aRect
*
*/
	static CRichTextEditorRTE* NewL(const CCoeControl& aView);

/*!
* NewLC()
*	 
*/
	static CRichTextEditorRTE* NewLC(const CCoeControl& aView);


public: // from CoeControl

	TKeyResponse OfferKeyEventL(const TKeyEvent& aKeyEvent, TEventCode aType);

public: // members

/* 
* AddCarriageReturnL ()
*   
* discussion Add one carriage return
*
*/
	void AddCarriageReturnL ();

/* 
* AddTextL (const TDesC& aText)
*   
* discussion Print text on the screen.
* param aText text to be displayed
*
*/
	void AddTextL (const TDesC& aText);

private: // Basic two-phase EPOC constructors

	void ConstructL(const CCoeControl& aView);

/*!
 * CRichTextEditorRTE()
 *
 * Default contructor.
 *
 */
	CRichTextEditorRTE();

private: //data

	// formatting options for the RichText that will be displayed
	TCharFormatMask iCharacterFormatMask;  
	TCharFormat iCharacterFormat; 
	};

#endif	// #ifndef CRICHTEXTEDITOR_H
