/*
* ============================================================================
*  Name     : CThreadAnimation from CThreadAnimation.h
*  Part of  : Thread
*  Created  : 04.02.2005 by Forum Nokia
*  Description:
*     Animation class that is used to animate thread state. While animation is
*     running a spiral is circulating. When thread is not alive then no animation
*     is showed.
*  Version  : 1.0
*  Copyright: Nokia Corporation
* ============================================================================
*/

#ifndef THREADANIMATION_H
#define THREADANIMATION_H

// INCLUDES
#include <coecntrl.h>
#include "e32base.h" 

// FORWARD DECLARATIONS
class CAknBitmapAnimation;

// CLASS DECLARATION

/**
*  CThreadAnimation Animates a thread.
*  
*/
class CThreadAnimation
	{
public:

/*!
 * NewL()
 * 
 * discussion Create new CThreadAnimation object
 * return a pointer to the created instance of CThreadAnimation
 * param aReader the resourcereader that contains one BMPANIM_DATA.
 * param aWindow Container window of this animation.
 */
	static CThreadAnimation* NewL(TResourceReader& aReader, RWindow& aWindow);
/*!
 * NewLC()
 *	 
 */
	static CThreadAnimation* NewLC(TResourceReader& aReader, RWindow& aWindow);


/*!
 * ~CThreadAnimation()
 *
 * Destructor.
 *
 */
	~CThreadAnimation(void);

/*!
 * StartAnimationL()
 *
 * discussion Starts thread animation. 
 *	 
 */
	void StartAnimationL();

/*!
 * StopAnimation()
 *
 * discussion Stops thread animation. Animation disappears from the screen.
 *	 
 */
	void StopAnimation();

private: // Basic two-phase EPOC constructors

/*!
 * CThreadAnimation()
 *
 * Default contructor.
 *
 */
	CThreadAnimation(void);

/*!
 * ConstructL()
 *
 * param aReader the resourcereader that contains one BMPANIM_DATA.
 * param aWindow Container window of this animation.
 */
	void ConstructL(TResourceReader& aReader, RWindow& aWindow);

private: // data members 
	// Bitmap animation .
	CAknBitmapAnimation* iAnimation;

	/// True if animation is running, false otherwise.
	TBool iRunning;
	};

#endif
